/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.interpolator.impl;

import net.raphimc.audiomixer.interpolator.Interpolator;
import net.raphimc.audiomixer.interpolator.impl.CubicInterpolator;
import net.raphimc.audiomixer.util.FastMath;

public class SincInterpolator
implements Interpolator {
    public static final SincInterpolator INSTANCE = new SincInterpolator(4);
    private final int radius;

    public SincInterpolator(int radius) {
        this.radius = radius;
    }

    @Override
    public float interpolate(float[] arr, double position, int offset, int channels) {
        int centerPosition = (int)position;
        int firstSamplePosition = centerPosition - this.radius + 1;
        int lastSamplePosition = centerPosition + this.radius;
        if (firstSamplePosition < 0 || lastSamplePosition * channels + offset >= arr.length) {
            return CubicInterpolator.INSTANCE.interpolate(arr, position, offset, channels);
        }
        float sum = 0.0f;
        float weightSum = 0.0f;
        for (int tap = firstSamplePosition; tap <= lastSamplePosition; ++tap) {
            float distance = (float)(position - (double)tap);
            float w = SincInterpolator.sinc(distance) * SincInterpolator.lanczosWindow(distance / (float)this.radius);
            sum += arr[tap * channels + offset] * w;
            weightSum += w;
        }
        return sum / weightSum;
    }

    private static float lanczosWindow(float x) {
        if (x <= -1.0f || x >= 1.0f) {
            return 0.0f;
        }
        return SincInterpolator.sinc(x);
    }

    private static float sinc(float x) {
        if (x == 0.0f) {
            return 1.0f;
        }
        double pix = Math.PI * (double)x;
        return (float)(FastMath.sin_roquen_newk(pix) / pix);
    }
}

