/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.interpolator.impl;

import net.raphimc.audiomixer.interpolator.Interpolator;
import net.raphimc.audiomixer.interpolator.impl.LinearInterpolator;

public class CubicInterpolator
implements Interpolator {
    public static final CubicInterpolator INSTANCE = new CubicInterpolator();

    @Override
    public float interpolate(float[] arr, double position, int offset, int channels) {
        int centerPosition = (int)position;
        if (centerPosition < 1 || (centerPosition + 2) * channels + offset >= arr.length) {
            return LinearInterpolator.INSTANCE.interpolate(arr, position, offset, channels);
        }
        float x0 = arr[(centerPosition - 1) * channels + offset];
        float x1 = arr[centerPosition * channels + offset];
        float x2 = arr[(centerPosition + 1) * channels + offset];
        float x3 = arr[(centerPosition + 2) * channels + offset];
        float a0 = -0.5f * x0 + 1.5f * x1 - 1.5f * x2 + 0.5f * x3;
        float a1 = x0 - 2.5f * x1 + 2.0f * x2 - 0.5f * x3;
        float a2 = -0.5f * x0 + 0.5f * x2;
        float a3 = x1;
        float t = (float)(position - (double)centerPosition);
        return ((a0 * t + a1) * t + a2) * t + a3;
    }
}

