/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.raphimc.audiomixer.AudioMixer;
import net.raphimc.audiomixer.soundmodifier.impl.NormalizationModifier;
import net.raphimc.audiomixer.soundmodifier.impl.VolumeModifier;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;
import net.raphimc.audiomixer.util.io.SampleOutputStream;

public class SourceDataLineAudioMixer
extends AudioMixer {
    private final SourceDataLine sourceDataLine;
    private final int sampleByteSize;
    private int mixSliceSampleCount;
    private BufferOverrunStrategy bufferOverrunStrategy = BufferOverrunStrategy.DO_NOTHING;
    private final NormalizationModifier normalizationModifier = new NormalizationModifier();
    private final VolumeModifier volumeModifier = new VolumeModifier(1.0f);

    public SourceDataLineAudioMixer(SourceDataLine sourceDataLine, int mixSliceMillis) throws LineUnavailableException {
        this(sourceDataLine, mixSliceMillis, Math.max(mixSliceMillis * 3, 50));
    }

    public SourceDataLineAudioMixer(SourceDataLine sourceDataLine, int mixSliceMillis, int bufferMillis) throws LineUnavailableException {
        super(new PcmFloatAudioFormat(sourceDataLine.getFormat()));
        this.sourceDataLine = sourceDataLine;
        this.sampleByteSize = sourceDataLine.getFormat().getSampleSizeInBits() / 8;
        this.mixSliceSampleCount = (int)Math.ceil(sourceDataLine.getFormat().getSampleRate() / 1000.0f * (float)mixSliceMillis) * sourceDataLine.getFormat().getChannels();
        if (!sourceDataLine.isOpen()) {
            int bufferSampleCount = (int)Math.ceil(sourceDataLine.getFormat().getSampleRate() / 1000.0f * (float)bufferMillis) * sourceDataLine.getFormat().getChannels();
            sourceDataLine.open(sourceDataLine.getFormat(), bufferSampleCount * this.sampleByteSize);
        }
        if (sourceDataLine.getBufferSize() < this.mixSliceSampleCount * 2 * this.sampleByteSize) {
            throw new IllegalArgumentException("SourceDataLine buffer has to be at least twice the size of the mix slice size");
        }
        sourceDataLine.start();
        this.getSoundModifiers().append(this.normalizationModifier);
        this.getSoundModifiers().append(this.volumeModifier);
    }

    @Override
    public void stopAllSounds() {
        super.stopAllSounds();
        this.normalizationModifier.reset();
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.sourceDataLine.getFormat();
    }

    public void close() {
        this.sourceDataLine.close();
    }

    public void mixSlice() {
        int samplesSize = this.mixSliceSampleCount * this.sampleByteSize;
        if (this.bufferOverrunStrategy == BufferOverrunStrategy.DO_NOTHING && this.sourceDataLine.available() < samplesSize) {
            return;
        }
        float[] samples = this.mix(this.mixSliceSampleCount);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(samplesSize);
        SampleOutputStream sos = new SampleOutputStream(baos, this.sourceDataLine.getFormat());
        try {
            for (float sample : samples) {
                sos.writeSample(sample);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] sampleData = baos.toByteArray();
        if (this.bufferOverrunStrategy == BufferOverrunStrategy.FLUSH && this.sourceDataLine.available() < sampleData.length) {
            this.sourceDataLine.flush();
        }
        this.sourceDataLine.write(sampleData, 0, sampleData.length);
    }

    public SourceDataLine getSourceDataLine() {
        return this.sourceDataLine;
    }

    public int getMixSliceSampleCount() {
        return this.mixSliceSampleCount;
    }

    public SourceDataLineAudioMixer setMixSliceSampleCount(int mixSliceSampleCount) {
        if (this.sourceDataLine.getBufferSize() < mixSliceSampleCount * 2 * this.sampleByteSize) {
            throw new IllegalArgumentException("SourceDataLine buffer is too small for the new mix slice size. Increase the SourceDataLine buffer size or reduce the mix slice size");
        }
        this.mixSliceSampleCount = mixSliceSampleCount;
        return this;
    }

    public SourceDataLineAudioMixer setMixSliceMillis(int mixSliceMillis) {
        return this.setMixSliceSampleCount((int)Math.ceil(this.getAudioFormat().getSampleRate() / 1000.0f * (float)mixSliceMillis) * this.getAudioFormat().getChannels());
    }

    public BufferOverrunStrategy getBufferOverrunStrategy() {
        return this.bufferOverrunStrategy;
    }

    public SourceDataLineAudioMixer setBufferOverrunStrategy(BufferOverrunStrategy bufferOverrunStrategy) {
        this.bufferOverrunStrategy = bufferOverrunStrategy;
        return this;
    }

    public VolumeModifier getVolumeModifier() {
        return this.volumeModifier;
    }

    public NormalizationModifier getNormalizationModifier() {
        return this.normalizationModifier;
    }

    public SourceDataLineAudioMixer setMasterVolume(int masterVolume) {
        return this.setMasterVolume((float)masterVolume / 100.0f);
    }

    public SourceDataLineAudioMixer setMasterVolume(float masterVolume) {
        this.volumeModifier.setVolume(masterVolume);
        return this;
    }

    public float getMasterVolume() {
        return this.volumeModifier.getVolume();
    }

    public int getBufferedSampleCount() {
        return (this.sourceDataLine.getBufferSize() - this.sourceDataLine.available()) / this.sampleByteSize;
    }

    public int getBufferedMillis() {
        return (int)((float)this.getBufferedSampleCount() / (float)this.getAudioFormat().getChannels() / this.getAudioFormat().getSampleRate() * 1000.0f);
    }

    public static enum BufferOverrunStrategy {
        DO_NOTHING,
        FLUSH,
        BLOCK;

    }
}

