/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.raphimc.audiomixer.SourceDataLineAudioMixer;
import net.raphimc.audiomixer.util.TimerHack;

public class BackgroundSourceDataLineAudioMixer
extends SourceDataLineAudioMixer {
    private final ScheduledExecutorService mixingScheduler;

    public BackgroundSourceDataLineAudioMixer(SourceDataLine sourceDataLine) throws LineUnavailableException {
        this(sourceDataLine, 20);
    }

    public BackgroundSourceDataLineAudioMixer(SourceDataLine sourceDataLine, int updatePeriodMillis) throws LineUnavailableException {
        super(sourceDataLine, updatePeriodMillis);
        TimerHack.ensureRunning();
        this.mixingScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "AudioMixer-MixingThread");
            thread.setPriority(6);
            thread.setDaemon(true);
            return thread;
        });
        this.mixingScheduler.scheduleAtFixedRate(this::mixSlice, updatePeriodMillis, updatePeriodMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public SourceDataLineAudioMixer setMixSliceSampleCount(int mixSliceSampleCount) {
        throw new UnsupportedOperationException("Cannot change mix slice size for auto-mixing audio mixer");
    }

    public boolean isRunning() {
        return !this.mixingScheduler.isTerminated();
    }

    @Override
    public void close() {
        this.mixingScheduler.shutdownNow();
        try {
            this.mixingScheduler.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.close();
    }
}

