/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer;

import javax.sound.sampled.AudioFormat;
import net.raphimc.audiomixer.sound.Sound;
import net.raphimc.audiomixer.sound.impl.SubMixSound;
import net.raphimc.audiomixer.soundmodifier.SoundModifiers;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;

public class AudioMixer {
    private final PcmFloatAudioFormat audioFormat;
    private final SubMixSound masterMixSound = new SubMixSound();

    public AudioMixer(PcmFloatAudioFormat audioFormat) {
        this.audioFormat = audioFormat;
    }

    public void playSound(Sound sound) {
        this.masterMixSound.playSound(sound);
    }

    public void stopSound(Sound sound) {
        this.masterMixSound.stopSound(sound);
    }

    public void stopAllSounds() {
        this.masterMixSound.stopAllSounds();
    }

    public SoundModifiers getSoundModifiers() {
        return this.masterMixSound.getSoundModifiers();
    }

    public float[] mixMillis(int millis) {
        return this.mix((int)Math.ceil(this.audioFormat.getSampleRate() / 1000.0f * (float)millis) * this.audioFormat.getChannels());
    }

    public float[] mix(int sampleCount) {
        if (sampleCount % this.audioFormat.getChannels() != 0) {
            throw new IllegalArgumentException("Sample count must be a multiple of the channel count");
        }
        float[] renderedSamples = new float[sampleCount];
        this.masterMixSound.render(this.audioFormat, renderedSamples);
        return renderedSamples;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public SubMixSound getMasterMixSound() {
        return this.masterMixSound;
    }
}

