/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.utils.string;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.quanter.shield.utils.maths.MathUtils;
import net.quanter.shield.utils.string.StringComplexity;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final int DEFAULT_STRING_LENGTH = 6;
    private static final char DEFAULT_STRING_SEPARATOR = ',';
    public static final Pattern HUMP_PATTERN = Pattern.compile("[A-Z]");
    public static final Pattern LINE_PATTERN = Pattern.compile("_(\\w)");
    public static final char UNDER_LINE = '_';

    public static String genString(int length, StringComplexity complexity) {
        length = length <= 0 ? 6 : length;
        complexity = complexity == null ? StringComplexity.defaultStringComplexity() : complexity;
        StringBuilder stringBuilder = new StringBuilder();
        char[] complexityArrayLength = complexity.getChars();
        for (int i = 0; i < length; ++i) {
            int index = MathUtils.getRandom(complexityArrayLength.length);
            stringBuilder.append(complexity.getChars()[index]);
        }
        return stringBuilder.toString();
    }

    public static String joinString(int[] array, char separator, String prefix, String suffix) {
        Preconditions.checkNotNull((Object)array);
        return prefix + org.apache.commons.lang3.StringUtils.join((int[])array, (char)separator) + suffix;
    }

    public static String joinString(long[] array, char separator, String prefix, String suffix) {
        Preconditions.checkNotNull((Object)array);
        return prefix + org.apache.commons.lang3.StringUtils.join((long[])array, (char)separator) + suffix;
    }

    public static String joinString(char[] array, char separator, String prefix, String suffix) {
        Preconditions.checkNotNull((Object)array);
        return prefix + org.apache.commons.lang3.StringUtils.join((char[])array, (char)separator) + suffix;
    }

    public static String joinString(double[] array, char separator, String prefix, String suffix) {
        Preconditions.checkNotNull((Object)array);
        return prefix + org.apache.commons.lang3.StringUtils.join((double[])array, (char)separator) + suffix;
    }

    public static String joinString(String[] array, String separator, String prefix, String suffix) {
        Preconditions.checkNotNull((Object)array);
        return prefix + org.apache.commons.lang3.StringUtils.join((Object[])array, (String)separator) + suffix;
    }

    public static String joinString(Iterable<?> array, String separator, String prefix, String suffix) {
        Preconditions.checkNotNull(array);
        return prefix + org.apache.commons.lang3.StringUtils.join(array, (String)separator) + suffix;
    }

    public static int[] stringToIntArray(String str) {
        Preconditions.checkNotNull((Object)str);
        return StringUtils.stringToIntArray(str, ',');
    }

    public static int[] stringToIntArray(String str, char separator) {
        return StringUtils.stringToIntArray(str, String.valueOf(separator));
    }

    public static int[] stringToIntArray(String str, String separator) {
        ArrayList list = new ArrayList();
        Splitter.on((String)separator).trimResults().omitEmptyStrings().split((CharSequence)str).forEach(x -> list.add(Integer.parseInt(x)));
        return Ints.toArray(list);
    }

    public static long[] stringToLongArray(String str) {
        return StringUtils.stringToLongArray(str, ',');
    }

    public static long[] stringToLongArray(String str, char separator) {
        return StringUtils.stringToLongArray(str, String.valueOf(separator));
    }

    public static long[] stringToLongArray(String str, String separator) {
        ArrayList list = new ArrayList();
        Splitter.on((String)separator).trimResults().omitEmptyStrings().split((CharSequence)str).forEach(x -> list.add(Long.parseLong(x)));
        return Longs.toArray(list);
    }

    public static double[] stringToDoubleArray(String str) {
        return StringUtils.stringToDoubleArray(str, ',');
    }

    public static double[] stringToDoubleArray(String str, char separator) {
        return StringUtils.stringToDoubleArray(str, String.valueOf(separator));
    }

    public static double[] stringToDoubleArray(String str, String separator) {
        ArrayList list = new ArrayList();
        Splitter.on((String)separator).trimResults().omitEmptyStrings().split((CharSequence)str).forEach(x -> list.add(Double.parseDouble(x)));
        return Doubles.toArray(list);
    }

    public static String humpToLine(String str) {
        if (str == null) {
            return null;
        }
        Matcher matcher = HUMP_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String lineToHump(String str) {
        Preconditions.checkNotNull((Object)str);
        Matcher matcher = LINE_PATTERN.matcher(str.toLowerCase());
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String replaceMiddleWith(String str, int maxLength, char c) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        if (str.length() < 3) {
            return str;
        }
        int length = maxLength < str.length() - 2 ? maxLength : str.length() - 2;
        int frontLength = (str.length() - length) / 2;
        return str.substring(0, frontLength) + String.valueOf(c).repeat(length) + str.substring(frontLength + length);
    }
}

