/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.utils.maths;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;

public class MathUtils {
    private static final Random r = new Random(System.currentTimeMillis());
    private static final int D = 3;
    static final double[] fp1 = new double[]{50.0};
    static final double[] fp2 = new double[]{50.0, 50.0};

    public static final double[] getMaxMin(double ... d) {
        double[] result = new double[]{Double.MIN_VALUE, Double.MAX_VALUE};
        for (int i = 0; i < d.length; ++i) {
            if (d[i] > result[0]) {
                result[0] = d[i];
            }
            if (!(d[i] < result[1])) continue;
            result[1] = d[i];
        }
        return result;
    }

    public static final double max(double ... d) {
        return MathUtils.getMaxMin(d)[0];
    }

    public static final double min(double ... d) {
        return MathUtils.getMaxMin(d)[1];
    }

    public static final double sum(double[] a) {
        if (a == null) {
            return Double.MIN_VALUE;
        }
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i];
        }
        return sum;
    }

    public static final double avg(double[] a) {
        if (a == null) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i];
        }
        return sum / (double)a.length;
    }

    public static final double std(double[] a) {
        if (a == null) {
            return 0.0;
        }
        double avg = MathUtils.avg(a);
        int num = a.length;
        double ma = 0.0;
        for (int i = 0; i < num; ++i) {
            ma += Math.pow(a[i] - avg, 2.0);
        }
        double sd = Math.sqrt(ma / (double)num);
        return sd;
    }

    public static final int getRandom(int max) {
        return r.nextInt(max);
    }

    public static double gaussian(double u) {
        double y = Math.abs(u);
        double y2 = y * y;
        double z = Math.exp(-0.5 * y2) * 0.3989422804014327;
        double p = 0.0;
        int k = 28;
        double s = -1.0;
        double fj = k;
        if (y > 3.0) {
            for (int i = 1; i <= k; ++i) {
                p = fj / (y + p);
                fj -= 1.0;
            }
            p = z / (y + p);
        } else {
            for (int i = 1; i <= k; ++i) {
                p = fj * y2 / (2.0 * fj + 1.0 + s * p);
                s = -s;
                fj -= 1.0;
            }
            p = 0.5 - z * y / (1.0 - p);
        }
        if (u > 0.0) {
            p = 1.0 - p;
        }
        return p;
    }

    public static double[] fibonacciPersent(int m, int a0, int a1) {
        int i;
        if (m <= 1) {
            return fp1;
        }
        if (m == 2) {
            return fp2;
        }
        int[] a = MathUtils.fibonacci(m, a0, a1);
        double[] b = new double[a.length];
        double sum = 0.0;
        for (i = 0; i < a.length; ++i) {
            sum += (double)a[i];
        }
        for (i = 0; i < b.length; ++i) {
            b[i] = (double)a[i] / sum;
        }
        return b;
    }

    public static int[] fibonacci(int m, int a0, int a1) {
        if (m <= 1) {
            return new int[]{a0};
        }
        if (m == 2) {
            return new int[]{a0, a1};
        }
        int[] a = new int[m];
        a[0] = a0;
        a[1] = a1;
        for (int i = 2; i < m; ++i) {
            a[i] = a[i - 1] + a[i - 2];
        }
        return a;
    }

    public static double round(double x, int size) {
        String s = String.valueOf(x);
        if (s.trim().length() < size + 1) {
            return x;
        }
        int point_index = s.indexOf(46);
        if (point_index < 1) {
            return new BigDecimal(x).setScale(0, RoundingMode.HALF_UP).doubleValue();
        }
        return new BigDecimal(x).setScale(size - point_index, RoundingMode.HALF_UP).doubleValue();
    }

    public static double floor(double x, double d) {
        int a = (int)(x / d);
        double b = (double)a * d;
        return b;
    }

    public static double ceil(double x, double d) {
        int a = (int)(x / d);
        double m = x % d;
        double b = (double)(a + (m == 0.0 ? 0 : 1)) * d;
        return b;
    }

    public static int floor(int x, int d) {
        int a = x / d;
        int b = a * d;
        return b;
    }

    public static int ceil(int x, int d) {
        int a = x / d;
        int m = x % d;
        int b = (a + (m == 0 ? 0 : 1)) * d;
        return b;
    }
}

