/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.utils.date;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.quanter.shield.common.dto.date.DataRegionDTO;
import net.quanter.shield.common.enums.date.Period;
import net.quanter.shield.utils.date.TimeZones;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    public static Date getStartTimeByPeriod(Date date, Period period) {
        return DateUtils.getStartTimeByPeriod(date, period, TimeZones.DEFATULT_TIME_ZONE);
    }

    public static Date getStartTimeByPeriodGMT(Date date, Period period) {
        return DateUtils.getStartTimeByPeriod(date, period, TimeZones.GMT_TIME_ZONE);
    }

    public static Date getStartTimeByPeriodUTC(Date date, Period period) {
        return DateUtils.getStartTimeByPeriod(date, period, TimeZones.UTC_TIME_ZONE);
    }

    public static Date getStartTimeByPeriodChina(Date date, Period period) {
        return DateUtils.getStartTimeByPeriod(date, period, TimeZones.CHINA_TIME_ZONE);
    }

    public static Date getStartTimeByPeriod(Date date, Period period, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone == null ? TimeZones.DEFATULT_TIME_ZONE : timeZone);
        calendar.setTime(date == null ? new Date() : date);
        calendar.set(14, 0);
        int second = calendar.get(13);
        int minute = calendar.get(12);
        int hour = calendar.get(11);
        switch (period) {
            case S1: {
                break;
            }
            case S5: {
                calendar.set(13, second < 5 ? 0 : second - second % 5);
                break;
            }
            case S10: {
                calendar.set(13, second < 10 ? 0 : second - second % 10);
                break;
            }
            case S15: {
                calendar.set(13, second < 15 ? 0 : second - second % 15);
                break;
            }
            case S30: {
                calendar.set(13, second < 30 ? 0 : second - second % 30);
                break;
            }
            case M1: {
                calendar.set(13, 0);
                break;
            }
            case M2: {
                calendar.set(13, 0);
                calendar.set(12, minute < 2 ? 0 : minute - minute % 2);
                break;
            }
            case M3: {
                calendar.set(13, 0);
                calendar.set(12, minute < 3 ? 0 : minute - minute % 3);
                break;
            }
            case M5: {
                calendar.set(13, 0);
                calendar.set(12, minute < 5 ? 0 : minute - minute % 5);
                break;
            }
            case M10: {
                calendar.set(13, 0);
                calendar.set(12, minute < 10 ? 0 : minute - minute % 10);
                break;
            }
            case M15: {
                calendar.set(13, 0);
                calendar.set(12, minute < 15 ? 0 : minute - minute % 15);
                break;
            }
            case M30: {
                calendar.set(13, 0);
                calendar.set(12, minute < 30 ? 0 : minute - minute % 30);
                break;
            }
            case H1: {
                DateUtils.resetHourTime(calendar);
                break;
            }
            case H2: {
                DateUtils.resetHourTime(calendar);
                calendar.set(11, hour < 2 ? 0 : hour - hour % 2);
                break;
            }
            case H4: {
                DateUtils.resetHourTime(calendar);
                calendar.set(11, hour < 4 ? 0 : hour - hour % 4);
                break;
            }
            case H6: {
                DateUtils.resetHourTime(calendar);
                calendar.set(11, hour < 6 ? 0 : hour - hour % 6);
                break;
            }
            case H12: {
                DateUtils.resetHourTime(calendar);
                calendar.set(11, hour < 12 ? 0 : hour - hour % 12);
                break;
            }
            case WEEK: {
                DateUtils.resetDayTime(calendar);
                calendar.set(7, 1);
                break;
            }
            case MONTH: {
                DateUtils.resetDayTime(calendar);
                calendar.set(5, 1);
                break;
            }
            case QUARTER: {
                DateUtils.resetDayTime(calendar);
                int month = calendar.get(2);
                calendar.set(5, 1);
                calendar.set(2, month < 2 ? 0 : month - month % 3);
                break;
            }
            case YEAR: {
                DateUtils.resetDayTime(calendar);
                calendar.set(6, 1);
                break;
            }
            default: {
                DateUtils.resetDayTime(calendar);
            }
        }
        return calendar.getTime();
    }

    public static Date getNextStartTimeByPeriod(Date date, Period period) {
        return DateUtils.getNextStartTimeByPeriod(date, period, TimeZones.DEFATULT_TIME_ZONE);
    }

    public static Date getNextStartTimeByPeriodGMT(Date date, Period period) {
        return DateUtils.getNextStartTimeByPeriod(date, period, TimeZones.GMT_TIME_ZONE);
    }

    public static Date getNextStartTimeByPeriodUTC(Date date, Period period) {
        return DateUtils.getNextStartTimeByPeriod(date, period, TimeZones.UTC_TIME_ZONE);
    }

    public static Date getNextStartTimeByPeriodChina(Date date, Period period) {
        return DateUtils.getNextStartTimeByPeriod(date, period, TimeZones.CHINA_TIME_ZONE);
    }

    public static Date getNextStartTimeByPeriod(Date date, Period period, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone == null ? TimeZones.DEFATULT_TIME_ZONE : timeZone);
        calendar.setTime(date == null ? new Date() : date);
        calendar.set(14, 0);
        int second = calendar.get(13);
        int minute = calendar.get(12);
        int hour = calendar.get(11);
        switch (period) {
            case S1: {
                calendar.add(13, 1);
                break;
            }
            case S5: {
                calendar.set(13, second < 5 ? 0 : second - second % 5);
                calendar.add(13, 5);
                break;
            }
            case S10: {
                calendar.set(13, second < 10 ? 0 : second - second % 10);
                calendar.add(13, 10);
                break;
            }
            case S15: {
                calendar.set(13, second < 15 ? 0 : second - second % 15);
                calendar.add(13, 15);
                break;
            }
            case S30: {
                calendar.set(13, second < 30 ? 0 : second - second % 30);
                calendar.add(13, 30);
                break;
            }
            case M1: {
                calendar.set(13, 0);
                calendar.add(12, 1);
                break;
            }
            case M2: {
                calendar.set(13, 0);
                calendar.set(12, minute < 2 ? 0 : minute - minute % 2);
                calendar.add(12, 2);
                break;
            }
            case M3: {
                calendar.set(13, 0);
                calendar.set(12, minute < 3 ? 0 : minute - minute % 3);
                calendar.add(12, 3);
                break;
            }
            case M5: {
                calendar.set(13, 0);
                calendar.set(12, minute < 5 ? 0 : minute - minute % 5);
                calendar.add(12, 5);
                break;
            }
            case M10: {
                calendar.set(13, 0);
                calendar.set(12, minute < 10 ? 0 : minute - minute % 10);
                calendar.add(12, 10);
                break;
            }
            case M15: {
                calendar.set(13, 0);
                calendar.set(12, minute < 15 ? 0 : minute - minute % 15);
                calendar.add(12, 15);
                break;
            }
            case M30: {
                calendar.set(13, 0);
                calendar.set(12, minute < 30 ? 0 : minute - minute % 30);
                calendar.add(12, 30);
                break;
            }
            case H1: {
                DateUtils.resetHourTime(calendar);
                calendar.add(11, 1);
                break;
            }
            case H2: {
                DateUtils.resetHourTime(calendar);
                calendar.set(11, hour < 2 ? 0 : hour - hour % 2);
                calendar.add(11, 2);
                break;
            }
            case H4: {
                DateUtils.resetHourTime(calendar);
                calendar.set(11, hour < 4 ? 0 : hour - hour % 4);
                calendar.add(11, 4);
                break;
            }
            case H6: {
                DateUtils.resetHourTime(calendar);
                calendar.set(11, hour < 6 ? 0 : hour - hour % 6);
                calendar.add(11, 6);
                break;
            }
            case H12: {
                DateUtils.resetHourTime(calendar);
                calendar.set(11, hour < 12 ? 0 : hour - hour % 12);
                calendar.add(11, 12);
                break;
            }
            case WEEK: {
                DateUtils.resetDayTime(calendar);
                calendar.set(7, 1);
                calendar.add(5, 7);
                break;
            }
            case MONTH: {
                DateUtils.resetDayTime(calendar);
                calendar.set(5, 1);
                calendar.add(2, 1);
                break;
            }
            case QUARTER: {
                DateUtils.resetDayTime(calendar);
                int month = calendar.get(2);
                calendar.set(5, 1);
                calendar.set(2, month < 2 ? 0 : month - month % 3);
                calendar.add(2, 3);
                break;
            }
            case YEAR: {
                DateUtils.resetDayTime(calendar);
                calendar.set(6, 1);
                calendar.add(1, 1);
                break;
            }
            default: {
                DateUtils.resetDayTime(calendar);
                calendar.add(5, 1);
            }
        }
        return calendar.getTime();
    }

    private static void resetHourTime(Calendar calendar) {
        calendar.set(13, 0);
        calendar.set(12, 0);
    }

    private static void resetDayTime(Calendar calendar) {
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
    }

    public static DataRegionDTO getDataRegion(Date date, Period period, TimeZone timeZone) {
        return new DataRegionDTO(DateUtils.getStartTimeByPeriod(date, period, timeZone), DateUtils.getNextStartTimeByPeriod(date, period, timeZone));
    }

    public static DataRegionDTO getDataRegion(Date date, Period period) {
        return DateUtils.getDataRegion(date, period, TimeZones.DEFATULT_TIME_ZONE);
    }

    public static DataRegionDTO getDataRegionGMT(Date date, Period period) {
        return DateUtils.getDataRegion(date, period, TimeZones.GMT_TIME_ZONE);
    }

    public static DataRegionDTO getDataRegionUTC(Date date, Period period) {
        return DateUtils.getDataRegion(date, period, TimeZones.UTC_TIME_ZONE);
    }

    public static DataRegionDTO getDataRegionChina(Date date, Period period) {
        return DateUtils.getDataRegion(date, period, TimeZones.CHINA_TIME_ZONE);
    }

    public static DataRegionDTO getDayRegion(int days, TimeZone timeZone) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.add(5, days);
        return DateUtils.getDataRegion(c.getTime(), Period.DAY, timeZone);
    }

    public static DataRegionDTO getToday(TimeZone timeZone) {
        return DateUtils.getDayRegion(0, timeZone);
    }

    public static DataRegionDTO getToday() {
        return DateUtils.getToday(TimeZones.DEFATULT_TIME_ZONE);
    }

    public static DataRegionDTO getTodayGMT() {
        return DateUtils.getToday(TimeZones.GMT_TIME_ZONE);
    }

    public static DataRegionDTO getTodayUTC() {
        return DateUtils.getToday(TimeZones.UTC_TIME_ZONE);
    }

    public static DataRegionDTO getTodayChina() {
        return DateUtils.getToday(TimeZones.CHINA_TIME_ZONE);
    }

    public static DataRegionDTO getYestoday(TimeZone timeZone) {
        return DateUtils.getDayRegion(-1, timeZone);
    }

    public static DataRegionDTO getYestoday() {
        return DateUtils.getYestoday(TimeZones.DEFATULT_TIME_ZONE);
    }

    public static DataRegionDTO getYestodayGMT() {
        return DateUtils.getYestoday(TimeZones.GMT_TIME_ZONE);
    }

    public static DataRegionDTO getYestodayUTC() {
        return DateUtils.getYestoday(TimeZones.UTC_TIME_ZONE);
    }

    public static DataRegionDTO getYestodayChina() {
        return DateUtils.getYestoday(TimeZones.CHINA_TIME_ZONE);
    }

    public static DataRegionDTO getTomorrow(TimeZone timeZone) {
        return DateUtils.getDayRegion(1, timeZone);
    }

    public static DataRegionDTO getTomorrow() {
        return DateUtils.getTomorrow(TimeZones.DEFATULT_TIME_ZONE);
    }

    public static DataRegionDTO getTomorrowUTC() {
        return DateUtils.getTomorrow(TimeZones.UTC_TIME_ZONE);
    }

    public static DataRegionDTO getTomorrowGMT() {
        return DateUtils.getTomorrow(TimeZones.GMT_TIME_ZONE);
    }

    public static DataRegionDTO getTomorrowChina() {
        return DateUtils.getTomorrow(TimeZones.CHINA_TIME_ZONE);
    }

    public static int getDiff(Date begin, Date end, Period period) {
        return (int)((end.getTime() - begin.getTime()) / period.milliSeconds);
    }

    public static boolean isWorkDay(Date date, TimeZone timeZone) {
        return !DateUtils.isWeekEnd(date, timeZone);
    }

    public static boolean isWorkDay(Date date) {
        return !DateUtils.isWeekEnd(date, TimeZones.DEFATULT_TIME_ZONE);
    }

    public static boolean isWorkDayGMT(Date date) {
        return !DateUtils.isWeekEnd(date, TimeZones.GMT_TIME_ZONE);
    }

    public static boolean isWorkDayUTC(Date date) {
        return !DateUtils.isWeekEnd(date, TimeZones.UTC_TIME_ZONE);
    }

    public static boolean isWorkDayChina(Date date) {
        return !DateUtils.isWeekEnd(date, TimeZones.CHINA_TIME_ZONE);
    }

    public static boolean isWeekEnd(Date date, TimeZone timeZone) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.setTime(date);
        int day_of_week = c.get(7);
        return day_of_week == 1 || day_of_week == 7;
    }

    public static boolean isWeekEnd(Date date) {
        return DateUtils.isWeekEnd(date, TimeZones.DEFATULT_TIME_ZONE);
    }

    public static boolean isWeekEndGMT(Date date) {
        return DateUtils.isWeekEnd(date, TimeZones.GMT_TIME_ZONE);
    }

    public static boolean isWeekEndUTC(Date date) {
        return DateUtils.isWeekEnd(date, TimeZones.UTC_TIME_ZONE);
    }

    public static boolean isWeekEndChina(Date date) {
        return DateUtils.isWeekEnd(date, TimeZones.CHINA_TIME_ZONE);
    }

    public static DataRegionDTO getFirstWorkDayForMonth(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        calendar.setTime(date);
        DateUtils.resetDayTime(calendar);
        calendar.set(5, 1);
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek == 7) {
            calendar.add(5, 2);
        }
        if (dayOfWeek == 1) {
            calendar.add(5, 1);
        }
        return DateUtils.getDataRegion(calendar.getTime(), Period.DAY, timeZone);
    }

    public static DataRegionDTO getFirstWorkDayForMonth(Date date) {
        return DateUtils.getFirstWorkDayForMonth(date, TimeZones.DEFATULT_TIME_ZONE);
    }

    public static DataRegionDTO getFirstWorkDayForMonthGMT(Date date) {
        return DateUtils.getFirstWorkDayForMonth(date, TimeZones.GMT_TIME_ZONE);
    }

    public static DataRegionDTO getFirstWorkDayForMonthUTC(Date date) {
        return DateUtils.getFirstWorkDayForMonth(date, TimeZones.UTC_TIME_ZONE);
    }

    public static DataRegionDTO getFirstWorkDayForMonthChina(Date date) {
        return DateUtils.getFirstWorkDayForMonth(date, TimeZones.CHINA_TIME_ZONE);
    }

    public static DataRegionDTO getLastWorkDayForMonth(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek == 7) {
            calendar.add(5, -1);
        }
        if (dayOfWeek == 1) {
            calendar.add(5, -2);
        }
        return DateUtils.getDataRegion(calendar.getTime(), Period.DAY, timeZone);
    }

    public static DataRegionDTO getLastWorkDayForMonthChina(Date date) {
        return DateUtils.getLastWorkDayForMonth(date, TimeZones.CHINA_TIME_ZONE);
    }
}

