/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.utils.date;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import net.quanter.shield.utils.date.TimeZones;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateFormatter
extends DateFormatUtils {
    public static final DateTimeFormatter DATE_FORMAT_STANDARD = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMAT_STANDARD_SIMPLE = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    public static final DateTimeFormatter DATE_FORMAT_SHORT = DateTimeFormatter.ofPattern("M-d H:m:s");
    public static final DateTimeFormatter DATE_FORMAT_FULL = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS E");
    public static final DateTimeFormatter DATE_FORMAT_FULL_SIMPLE = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    public static final DateTimeFormatter DATE_FORMAT_MS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    public static final DateTimeFormatter DATE_FORMAT_YMD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DATE_FORMAT_YMD_SIMPLE = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final DateTimeFormatter DATE_FORMAT_YM_SIMPLE = DateTimeFormatter.ofPattern("yyyyMM");
    public static final DateTimeFormatter DATE_FORMAT_MD_SIMPLE = DateTimeFormatter.ofPattern("MMdd");
    public static final DateTimeFormatter DATE_FORMAT_YMDHM_SIMPLE = DateTimeFormatter.ofPattern("yyyyMMddHHmm");

    private static LocalDateTime dateToLocalDateTime(Date date, ZoneId zoneId) {
        return date.toInstant().atZone(zoneId).toLocalDateTime();
    }

    private static LocalDateTime dateToLocalDateTime(long time, ZoneId zoneId) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(time), zoneId);
    }

    public static String format(Date date) {
        return DateFormatter.format(date, DATE_FORMAT_STANDARD);
    }

    public static String formatNow(DateTimeFormatter formatter) {
        ZonedDateTime zdt = ZonedDateTime.now();
        return formatter.format(zdt);
    }

    public static String formatNowGMT(DateTimeFormatter formatter) {
        ZonedDateTime zdt = ZonedDateTime.now(TimeZones.GMT_ZONE_ID);
        return formatter.format(zdt);
    }

    public static String formatNowChina(DateTimeFormatter formatter) {
        ZonedDateTime zdt = ZonedDateTime.now(TimeZones.CHINA_ZONE_ID);
        return formatter.format(zdt);
    }

    public static String format(Date date, DateTimeFormatter formatter) {
        DateFormatUtils.format((Date)date, (String)"");
        return DateFormatter.dateToLocalDateTime(date, TimeZones.DEFAULT_ZONE_ID).format(formatter);
    }

    public static String format(long time, DateTimeFormatter formatter) {
        return formatter.format(DateFormatter.dateToLocalDateTime(time, TimeZones.DEFAULT_ZONE_ID));
    }

    public static String formatGMT(Date date, DateTimeFormatter formatter) {
        return DateFormatter.dateToLocalDateTime(date, TimeZones.GMT_ZONE_ID).format(formatter);
    }

    public static String formatGMT(long time, DateTimeFormatter formatter) {
        return formatter.format(DateFormatter.dateToLocalDateTime(time, TimeZones.GMT_ZONE_ID));
    }

    public static String formatUTC(Date date, DateTimeFormatter formatter) {
        return DateFormatter.dateToLocalDateTime(date, TimeZones.UTC_ZONE_ID).format(formatter);
    }

    public static String formatUTC(long time, DateTimeFormatter formatter) {
        return formatter.format(DateFormatter.dateToLocalDateTime(time, TimeZones.UTC_ZONE_ID));
    }

    public static String formatChina(Date date, DateTimeFormatter formatter) {
        return DateFormatter.dateToLocalDateTime(date, TimeZones.CHINA_ZONE_ID).format(formatter);
    }

    public static String formatChina(long time, DateTimeFormatter formatter) {
        return formatter.format(DateFormatter.dateToLocalDateTime(time, TimeZones.CHINA_ZONE_ID));
    }

    public static Date parse(String str, DateTimeFormatter formatter) {
        LocalDateTime localDateTime = LocalDateTime.parse(str, formatter);
        return Date.from(localDateTime.atZone(TimeZones.DEFAULT_ZONE_ID).toInstant());
    }

    public static Date parseGMT(String str, DateTimeFormatter formatter) {
        LocalDateTime localDateTime = LocalDateTime.parse(str, formatter);
        return Date.from(localDateTime.atZone(TimeZones.GMT_ZONE_ID).toInstant());
    }

    public static Date parseUTC(String str, DateTimeFormatter formatter) {
        LocalDateTime localDateTime = LocalDateTime.parse(str, formatter);
        return Date.from(localDateTime.atZone(TimeZones.UTC_ZONE_ID).toInstant());
    }

    public static Date parseChina(String str, DateTimeFormatter formatter) {
        LocalDateTime localDateTime = LocalDateTime.parse(str, formatter);
        return Date.from(localDateTime.atZone(TimeZones.CHINA_ZONE_ID).toInstant());
    }
}

