package net.quanter.shield.springboot.h2;

import org.h2.server.web.WebServlet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.h2.H2ConsoleProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(H2ConsoleProperties.class)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(WebServlet.class)
@ConditionalOnProperty(prefix = "spring.h2.console", name = "enabled", havingValue = "true", matchIfMissing = false)
public class SheildH2ConsoleAutoConfiguration {


    @Value("${spring.h2.console.settings.ifExists:true}")
    boolean ifExists;


    private final H2ConsoleProperties properties;

    public SheildH2ConsoleAutoConfiguration(H2ConsoleProperties properties) {
        this.properties = properties;
    }
    @Primary
    @Bean
    public ServletRegistrationBean<WebServlet> Shieldh2Console() {
        String path = this.properties.getPath();
        String urlMapping = path + (path.endsWith("/") ? "*" : "/*");
        ServletRegistrationBean<WebServlet> registration = new ServletRegistrationBean<>(new WebServlet(), urlMapping);
        H2ConsoleProperties.Settings settings = this.properties.getSettings();
        if (settings.isTrace()) {
            registration.addInitParameter("trace", "");
        }
        if (settings.isWebAllowOthers()) {
            registration.addInitParameter("webAllowOthers", "");
        }
        if(ifExists){
            registration.addInitParameter("ifExists","");
        }else {
            registration.addInitParameter("ifNotExists","");
        }
        return registration;
    }


//    @PostConstruct
    public void init(){
//        if(ctx.containsBean("h2Console")){
//            ServletRegistrationBean h2Console =  ctx.getBean("h2Console",ServletRegistrationBean.class);
//            h2Console.getInitParameters().put("ifExists",ifExists.toString());
////            servletRegistration.setInitParameter();
//
//        }
    }

}
