package net.quanter.shield.springboot.exception;

import net.quanter.shield.springboot.constant.GlobalConstants;

/**
 * shield-springboot
 * 应用异常
 * @author: harley-dog
 * 2019-06-17 10:13
 */

public abstract class ApplicationException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    private String code = GlobalConstants.RESULT_CODE_FAILURE;

    public ApplicationException(String message) {
        super(message);
    }

    public ApplicationException(Throwable cause) {
        super(cause);
    }

    public ApplicationException(String message, Throwable cause) {
        super(message, cause);
    }

    public ApplicationException(String code, String message) {
        super(message);
        setCode(code);
    }

    public ApplicationException(String code, String message, Throwable cause) {
        super(message, cause);
        setCode(code);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
