package net.quanter.shield.springboot.controller;

import lombok.extern.slf4j.Slf4j;
import net.quanter.shield.common.dto.ResultDTO;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.PostConstruct;

@RestController
@RequestMapping("")
@Slf4j
public class IndexController {

    @Value("${spring.application.name}")
    String appname;

    ResultDTO<String> indexResult;

    @PostConstruct
    public void init(){
        log.info("------------------------------------------------");
        log.info("---this is a shield springboot application------");
        log.info("-----------"+appname+" starting-----------------");
        log.info("-------------wrote by hayley.dog----------------");
        log.info("------------support by quanter.net--------------");
        log.info("------------------------------------------------");
        indexResult = ResultDTO.success().data(appname).build();
    }


    @GetMapping("")
    public ResultDTO<String> index(){
        return indexResult;
    }


    @GetMapping("/check")
    public String check(){
        return "success";
    }
}
