/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.springboot.mybatis.page;

import javax.servlet.http.HttpServletRequest;
import net.quanter.shield.mybatis.pagehelper.PageUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
@Component
public class PageInterceptor {
    @Pointcut(value="@annotation(net.quanter.shield.springboot.page.PageSupport)")
    private void page() {
    }

    @Before(value="page()")
    public void before(JoinPoint joinPoint) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = (HttpServletRequest)requestAttributes.resolveReference("request");
        String sPageNum = request.getParameter("pageNum");
        String sPageSize = request.getParameter("pageSize");
        if (sPageNum == null || sPageSize == null) {
            return;
        }
        Integer pageNum = Integer.parseInt(sPageNum);
        Integer pageSize = Integer.parseInt(sPageSize);
        PageUtil.set((Integer)pageNum, (Integer)pageSize);
    }

    @After(value="page()")
    public void afterCompletion() throws Exception {
        PageUtil.remove();
    }
}

