package net.quanter.shield.springboot.mybatis.page;

import net.quanter.shield.mybatis.pagehelper.PageUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;

/**
 * 分页拦截器，拦截web请求，直接把pageNum和pageSize放到前端中
 * Created by 2016/11/24.
 * @author harley-dog
 */
@Aspect
@Component
public class PageInterceptor {

    @Pointcut("@annotation(net.quanter.shield.springboot.page.PageSupport)")
    private void page(){}

    @Before(value = "page()")
    public void before(JoinPoint joinPoint) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        //从获取RequestAttributes中获取HttpServletRequest的信息
        HttpServletRequest request = (HttpServletRequest) requestAttributes.resolveReference(RequestAttributes.REFERENCE_REQUEST);
        String sPageNum = request.getParameter("pageNum");
        String sPageSize = request.getParameter("pageSize");
        if(sPageNum==null || sPageSize==null){
            return;
        }
        Integer pageNum = Integer.parseInt(sPageNum);
        Integer pageSize = Integer.parseInt(sPageSize);
        PageUtil.set(pageNum,pageSize);
    }

    @After(value = "page()")
    public void afterCompletion() throws Exception {
        PageUtil.remove();
    }

}

