/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.mq.rocketmq.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.convert.Convert;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

public class ObjectUtils {
    public static Object byteArrayToObject(Type type, byte[] b) {
        byte[] decode = Base64.decode((byte[])b);
        if (String.class.getTypeName().equals(type.getTypeName())) {
            return new String(decode, StandardCharsets.UTF_8);
        }
        if (Integer.class.getTypeName().equals(type.getTypeName())) {
            String str = new String(decode, StandardCharsets.UTF_8);
            return Integer.parseInt(str);
        }
        if (Long.class.getTypeName().equals(type.getTypeName())) {
            String str = new String(decode, StandardCharsets.UTF_8);
            return Long.parseLong(str);
        }
        if (Short.class.getTypeName().equals(type.getTypeName())) {
            String str = new String(decode, StandardCharsets.UTF_8);
            return Short.parseShort(str);
        }
        if (Double.class.getTypeName().equals(type.getTypeName())) {
            String str = new String(decode, StandardCharsets.UTF_8);
            return Double.parseDouble(str);
        }
        if (Float.class.getTypeName().equals(type.getTypeName())) {
            String str = new String(decode, StandardCharsets.UTF_8);
            return Float.valueOf(Float.parseFloat(str));
        }
        return Convert.convert((Type)type, (Object)decode);
    }

    public static byte[] objectToByteArray(Object obj) {
        if (obj == null) {
            return new byte[0];
        }
        Class<?> c = obj.getClass();
        if (String.class.equals(c)) {
            String str = (String)obj;
            byte[] b = ObjectUtils.stringToByteArray(str);
            return Base64.encode((byte[])b, (boolean)false);
        }
        if (Integer.class.equals(c) || Long.class.equals(c) || Short.class.equals(c) || Double.class.equals(c) || Float.class.equals(c)) {
            String str = obj.toString();
            byte[] b = ObjectUtils.stringToByteArray(str);
            return Base64.encode((byte[])b, (boolean)false);
        }
        return Base64.encode((byte[])Convert.toPrimitiveByteArray((Object)obj), (boolean)false);
    }

    public static byte[] stringToByteArray(String obj) {
        return obj.getBytes(StandardCharsets.UTF_8);
    }
}

