/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.mq.rocketmq.producer;

import com.alibaba.fastjson2.JSON;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import java.util.Map;
import java.util.Properties;
import net.quanter.shield.common.dto.result.ResultDTO;
import net.quanter.shield.mq.MQMessageVO;
import net.quanter.shield.mq.MQProducer;
import net.quanter.shield.mq.rocketmq.param.RocketMQBorkerParam;
import net.quanter.shield.mq.rocketmq.param.RocketMQTopicParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQTcpProducer<T>
implements MQProducer<T, Message> {
    private static final Logger log = LoggerFactory.getLogger(RocketMQTcpProducer.class);
    final RocketMQBorkerParam mqConnectVO;
    final RocketMQTopicParam topic;
    final Producer tcpProducer;

    public RocketMQTcpProducer(RocketMQBorkerParam mqConnectVO, RocketMQTopicParam topic) {
        this.mqConnectVO = mqConnectVO;
        this.topic = topic;
        Properties properties = new Properties();
        properties.put("AccessKey", mqConnectVO.getAccessId());
        properties.put("SecretKey", mqConnectVO.getAccessKey());
        properties.setProperty("SendMsgTimeoutMillis", "2000");
        properties.put("NAMESRV_ADDR", mqConnectVO.getEndPoint());
        this.tcpProducer = ONSFactory.createProducer((Properties)properties);
        this.tcpProducer.start();
    }

    @Override
    public Message getSourceMessageFromMQMessage(MQMessageVO mqMessageVO) {
        Message message = new Message(mqMessageVO.getTopic(), mqMessageVO.getTag(), mqMessageVO.getBase64Obj());
        message.setShardingKey(mqMessageVO.getShardKey());
        message.setMsgID(mqMessageVO.getMessageId());
        Map<String, String> properties = mqMessageVO.getProperties();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            message.putUserProperties(entry.getKey(), entry.getValue());
        }
        return message;
    }

    @Override
    public ResultDTO send(MQMessageVO mqMessageVO, Message message) {
        try {
            SendResult sendResult = this.tcpProducer.send(message);
            if (sendResult.getMessageId() != null) {
                mqMessageVO.setMessageId(sendResult.getMessageId());
            }
            mqMessageVO.setMessageId(sendResult.getMessageId());
            mqMessageVO.setRequestId(sendResult.getMessageId());
            return ResultDTO.SUCCESS;
        }
        catch (Throwable e) {
            log.error("RocketMQTcpProducer send error,mqMessageVO={}", JSON.toJSON((Object)mqMessageVO), (Object)e);
            return ResultDTO.failure().message(e.getMessage());
        }
    }

    @Override
    public void close() {
        this.tcpProducer.shutdown();
    }
}

