/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.mq.rocketmq.producer;

import com.alibaba.fastjson2.JSON;
import java.util.Map;
import net.quanter.shield.common.dto.result.ResultDTO;
import net.quanter.shield.mq.MQMessageVO;
import net.quanter.shield.mq.MQProducer;
import net.quanter.shield.mq.rocketmq.param.RocketMQBorkerParam;
import net.quanter.shield.mq.rocketmq.param.RocketMQTopicParam;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQCommunityProducer<T>
implements MQProducer<T, Message> {
    private static final Logger log = LoggerFactory.getLogger(RocketMQCommunityProducer.class);
    private final RocketMQBorkerParam mqBorkerParam;
    private final DefaultMQProducer producer;
    private final RocketMQTopicParam topic;

    public RocketMQCommunityProducer(RocketMQBorkerParam mqBorkerParam, RocketMQTopicParam topic, String producerGroup) throws MQClientException {
        this.mqBorkerParam = mqBorkerParam;
        this.topic = topic;
        this.producer = new DefaultMQProducer(producerGroup);
        this.producer.setNamesrvAddr(mqBorkerParam.getEndPoint());
        this.producer.start();
    }

    @Override
    public Message getSourceMessageFromMQMessage(MQMessageVO<T> mqMessageVO) {
        Message message = new Message();
        message.setBody(mqMessageVO.getBase64Obj());
        message.setTopic(mqMessageVO.getTopic());
        message.setTags(mqMessageVO.getTag());
        message.setKeys(mqMessageVO.getMessageId());
        for (Map.Entry<String, String> entry : mqMessageVO.getProperties().entrySet()) {
            message.putUserProperty(entry.getKey(), entry.getValue());
        }
        return message;
    }

    @Override
    public ResultDTO send(MQMessageVO mqMessageVO, Message message) {
        try {
            SendResult sendResult = this.producer.send(message);
            if (sendResult.getSendStatus() == SendStatus.SEND_OK) {
                mqMessageVO.setMessageId(sendResult.getMsgId());
                return ResultDTO.TRUE;
            }
            return ResultDTO.failure().message(sendResult.getSendStatus().name());
        }
        catch (Exception e) {
            log.error("RocketMQCommunityProducer send error,mqMessageVO={}", JSON.toJSON((Object)mqMessageVO), (Object)e);
            return ResultDTO.failure().message(e.getMessage());
        }
    }

    @Override
    public void close() {
        this.producer.shutdown();
    }
}

