/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.mq.rocketmq.producer;

import java.util.Map;
import net.quanter.shield.common.dto.result.ResultDTO;
import net.quanter.shield.mq.MQMessageVO;
import net.quanter.shield.mq.MQProducer;
import net.quanter.shield.mq.rocketmq.enums.RocketMqType;
import net.quanter.shield.mq.rocketmq.param.RocketMQBorkerParam;
import net.quanter.shield.mq.rocketmq.param.RocketMQTopicParam;
import net.quanter.shield.mq.rocketmq.producer.MQMessageSendHandler;
import net.quanter.shield.mq.rocketmq.producer.RocketMQCommunityProducer;
import net.quanter.shield.mq.rocketmq.producer.RocketMQHttpProducer;
import net.quanter.shield.mq.rocketmq.producer.RocketMQTcpProducer;

public class DefaultMQPushProducerWrapper {
    static final ResultDTO cannotSendMQResultDTO = ResultDTO.failure((String)"message can't to be send", (Integer)7002);
    static final ResultDTO messageCantNotBeNull = ResultDTO.failure((String)"message can't be null", (Integer)7003);
    final MQProducer rocketMQProducer;
    final MQMessageSendHandler mqMessageSendHandler;
    final RocketMQTopicParam topic;

    public DefaultMQPushProducerWrapper(RocketMqType type, String producerGroup, RocketMQBorkerParam mqConnectVO, RocketMQTopicParam topic, MQMessageSendHandler mqMessageSendHandler) throws Exception {
        this.mqMessageSendHandler = mqMessageSendHandler;
        this.topic = topic;
        this.rocketMQProducer = type == RocketMqType.HTTP ? new RocketMQHttpProducer(mqConnectVO, topic) : (type == RocketMqType.TCP ? new RocketMQTcpProducer(mqConnectVO, topic) : new RocketMQCommunityProducer(mqConnectVO, topic, producerGroup));
    }

    public <T> ResultDTO<MQMessageVO<T>> sendMessage(String tag, String shardKey, T obj, Map<String, String> properties, String messageId) {
        MQMessageVO<T> mqMessageVO = this.rocketMQProducer.getMQMessage(obj, tag, shardKey, this.topic.getName(), properties, messageId);
        boolean canContinue = true;
        if (this.mqMessageSendHandler != null) {
            canContinue = this.mqMessageSendHandler.beforeSend(mqMessageVO);
        }
        if (canContinue) {
            Object soureMessage = this.rocketMQProducer.getSourceMessageFromMQMessage(mqMessageVO);
            ResultDTO sendResult = this.rocketMQProducer.send(mqMessageVO, soureMessage);
            if (this.mqMessageSendHandler != null) {
                this.mqMessageSendHandler.afterSend(sendResult, mqMessageVO);
            }
            if (sendResult.isSuccess()) {
                return ResultDTO.success(mqMessageVO);
            }
            return sendResult;
        }
        return cannotSendMQResultDTO;
    }

    public <T> ResultDTO<MQMessageVO<T>> sendMessage(String tag, T obj) {
        if (obj == null || tag == null) {
            return messageCantNotBeNull;
        }
        return this.sendMessage(tag, obj.toString(), obj, null, null);
    }

    public <T> ResultDTO<MQMessageVO<T>> sendMessage(String tag, String shardKey, T obj) {
        if (obj == null || tag == null) {
            return messageCantNotBeNull;
        }
        return this.sendMessage(tag, shardKey, obj, null, null);
    }

    public <T> ResultDTO<MQMessageVO<T>> sendMessage(String tag, String shardKey, T obj, Map<String, String> properties) {
        return this.sendMessage(tag, shardKey, obj, properties, null);
    }

    public void close() {
        this.rocketMQProducer.close();
    }
}

