/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.mq.rocketmq.consumer;

import java.util.HashSet;
import net.quanter.shield.mq.rocketmq.consumer.RocketMQPushMessageListener;
import net.quanter.shield.mq.rocketmq.param.RocketMQTopicParam;
import org.apache.commons.lang3.StringUtils;

public class RocketMQConsumerParam {
    final RocketMQTopicParam topic;
    final RocketMQPushMessageListener listener;
    final HashSet<String> tagSet;
    String tagString;

    public RocketMQConsumerParam(RocketMQPushMessageListener listener, RocketMQTopicParam topicParam, String ... tags) {
        this.listener = listener;
        this.topic = topicParam;
        this.tagSet = new HashSet();
        if (tags != null) {
            for (String tag : tags) {
                this.tagSet.add(tag);
            }
        }
        this.tagString = this.tagSet.isEmpty() ? "*" : StringUtils.join(this.tagSet, (String)"||");
    }

    public boolean containTag(String tag) {
        if (this.tagSet.isEmpty()) {
            return true;
        }
        return this.tagSet.contains(tag);
    }

    public void setTagString(String tagString) {
        this.tagString = tagString;
    }

    public String getTopicAndTagString() {
        String topicName = this.topic.getName();
        String topicAndTagString = topicName + "_" + this.getTagString();
        return topicAndTagString;
    }

    public String toString() {
        return "[topic=" + this.topic + ", tagSet=" + this.tagSet + "].listener=" + this.listener.getClass().getName() + "}";
    }

    public RocketMQTopicParam getTopic() {
        return this.topic;
    }

    public RocketMQPushMessageListener getListener() {
        return this.listener;
    }

    public HashSet<String> getTagSet() {
        return this.tagSet;
    }

    public String getTagString() {
        return this.tagString;
    }
}

