/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.mq;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.quanter.shield.mq.rocketmq.utils.ObjectUtils;

public class MQMessageVO<T>
implements Serializable {
    private static final long serialVersionUID = -223423340408383597L;
    private String topic;
    private String tag;
    private String shardKey;
    private T obj;
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private Long offset;
    private Long queueOffset;
    private String messageId;
    private String requestId;
    private String messageMD5;
    private Long publishTime;
    private Long firstConsumeTime;
    private Long nextConsumeTime;
    private Integer consumedTimes;

    public void put(String key, String value) {
        this.properties.put(key, value);
    }

    public void putAll(Map<String, String> map) {
        this.properties.putAll(map);
    }

    public byte[] getBase64Obj() {
        return ObjectUtils.objectToByteArray(this.obj);
    }

    public String getMsgId() {
        if (this.properties.containsKey("ROCKET_MQ_MSGID")) {
            return this.properties.get("ROCKET_MQ_MSGID");
        }
        return this.messageId;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getTag() {
        return this.tag;
    }

    public String getShardKey() {
        return this.shardKey;
    }

    public T getObj() {
        return this.obj;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Long getOffset() {
        return this.offset;
    }

    public Long getQueueOffset() {
        return this.queueOffset;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getMessageMD5() {
        return this.messageMD5;
    }

    public Long getPublishTime() {
        return this.publishTime;
    }

    public Long getFirstConsumeTime() {
        return this.firstConsumeTime;
    }

    public Long getNextConsumeTime() {
        return this.nextConsumeTime;
    }

    public Integer getConsumedTimes() {
        return this.consumedTimes;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setShardKey(String shardKey) {
        this.shardKey = shardKey;
    }

    public void setObj(T obj) {
        this.obj = obj;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public void setQueueOffset(Long queueOffset) {
        this.queueOffset = queueOffset;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setMessageMD5(String messageMD5) {
        this.messageMD5 = messageMD5;
    }

    public void setPublishTime(Long publishTime) {
        this.publishTime = publishTime;
    }

    public void setFirstConsumeTime(Long firstConsumeTime) {
        this.firstConsumeTime = firstConsumeTime;
    }

    public void setNextConsumeTime(Long nextConsumeTime) {
        this.nextConsumeTime = nextConsumeTime;
    }

    public void setConsumedTimes(Integer consumedTimes) {
        this.consumedTimes = consumedTimes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MQMessageVO)) {
            return false;
        }
        MQMessageVO other = (MQMessageVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$offset = this.getOffset();
        Long other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Long this$queueOffset = this.getQueueOffset();
        Long other$queueOffset = other.getQueueOffset();
        if (this$queueOffset == null ? other$queueOffset != null : !((Object)this$queueOffset).equals(other$queueOffset)) {
            return false;
        }
        Long this$publishTime = this.getPublishTime();
        Long other$publishTime = other.getPublishTime();
        if (this$publishTime == null ? other$publishTime != null : !((Object)this$publishTime).equals(other$publishTime)) {
            return false;
        }
        Long this$firstConsumeTime = this.getFirstConsumeTime();
        Long other$firstConsumeTime = other.getFirstConsumeTime();
        if (this$firstConsumeTime == null ? other$firstConsumeTime != null : !((Object)this$firstConsumeTime).equals(other$firstConsumeTime)) {
            return false;
        }
        Long this$nextConsumeTime = this.getNextConsumeTime();
        Long other$nextConsumeTime = other.getNextConsumeTime();
        if (this$nextConsumeTime == null ? other$nextConsumeTime != null : !((Object)this$nextConsumeTime).equals(other$nextConsumeTime)) {
            return false;
        }
        Integer this$consumedTimes = this.getConsumedTimes();
        Integer other$consumedTimes = other.getConsumedTimes();
        if (this$consumedTimes == null ? other$consumedTimes != null : !((Object)this$consumedTimes).equals(other$consumedTimes)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$shardKey = this.getShardKey();
        String other$shardKey = other.getShardKey();
        if (this$shardKey == null ? other$shardKey != null : !this$shardKey.equals(other$shardKey)) {
            return false;
        }
        T this$obj = this.getObj();
        T other$obj = other.getObj();
        if (this$obj == null ? other$obj != null : !this$obj.equals(other$obj)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$messageMD5 = this.getMessageMD5();
        String other$messageMD5 = other.getMessageMD5();
        return !(this$messageMD5 == null ? other$messageMD5 != null : !this$messageMD5.equals(other$messageMD5));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MQMessageVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Long $queueOffset = this.getQueueOffset();
        result = result * 59 + ($queueOffset == null ? 43 : ((Object)$queueOffset).hashCode());
        Long $publishTime = this.getPublishTime();
        result = result * 59 + ($publishTime == null ? 43 : ((Object)$publishTime).hashCode());
        Long $firstConsumeTime = this.getFirstConsumeTime();
        result = result * 59 + ($firstConsumeTime == null ? 43 : ((Object)$firstConsumeTime).hashCode());
        Long $nextConsumeTime = this.getNextConsumeTime();
        result = result * 59 + ($nextConsumeTime == null ? 43 : ((Object)$nextConsumeTime).hashCode());
        Integer $consumedTimes = this.getConsumedTimes();
        result = result * 59 + ($consumedTimes == null ? 43 : ((Object)$consumedTimes).hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $shardKey = this.getShardKey();
        result = result * 59 + ($shardKey == null ? 43 : $shardKey.hashCode());
        T $obj = this.getObj();
        result = result * 59 + ($obj == null ? 43 : $obj.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $messageMD5 = this.getMessageMD5();
        result = result * 59 + ($messageMD5 == null ? 43 : $messageMD5.hashCode());
        return result;
    }

    public String toString() {
        return "MQMessageVO(topic=" + this.getTopic() + ", tag=" + this.getTag() + ", shardKey=" + this.getShardKey() + ", obj=" + this.getObj() + ", properties=" + this.getProperties() + ", offset=" + this.getOffset() + ", queueOffset=" + this.getQueueOffset() + ", messageId=" + this.getMessageId() + ", requestId=" + this.getRequestId() + ", messageMD5=" + this.getMessageMD5() + ", publishTime=" + this.getPublishTime() + ", firstConsumeTime=" + this.getFirstConsumeTime() + ", nextConsumeTime=" + this.getNextConsumeTime() + ", consumedTimes=" + this.getConsumedTimes() + ")";
    }
}

