package net.quanter.shield.mybatis.pagehelper;

import com.github.pagehelper.ISelect;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import lombok.Getter;
import net.quanter.shield.common.dto.ResultDTO;

import java.util.List;

public class FullPageResultDTO extends ResultDTO<List> {

    /** 分页对象 */
    @Getter
    private FullPageInfoDTO page;

    private static final PageDTO defaultPageDTO = new PageDTO(10);

    public FullPageResultDTO() {
    }

    public FullPageResultDTO(List data) {
        super(data);
    }

    public FullPageResultDTO(List data, FullPageInfoDTO pageInfoDTO) {
        super(data);
        this.page = pageInfoDTO;
    }

    public FullPageResultDTO(boolean success, String message, String code,List data) {
        super(success, message,code, data);
    }

    public FullPageResultDTO(ResultDTO result) {
        super(result);
    }

    public static ResultDTO doSelectInfo(ISelect select){
        PageDTO pageDTO = PageUtil.get();
        if(pageDTO==null){
            pageDTO = defaultPageDTO;
        }
        PageInfo pageInfo = PageHelper
                .startPage(pageDTO.getPageNum(),pageDTO.getPageSize(),true,pageDTO.getReasonable(),pageDTO.getPageSizeZero())
                .doSelectPageInfo(select);
        return create(pageInfo);
    }

    public static FullPageResultDTO create(PageInfo pageInfo){
        FullPageInfoDTO pageInfoDTO = new FullPageInfoDTO();
        pageInfoDTO.setStartRow(pageInfo.getStartRow());
        pageInfoDTO.setPageSize(pageInfo.getPageSize());
        pageInfoDTO.setTotal(pageInfo.getTotal());
        pageInfoDTO.setSize(pageInfo.getSize());
        pageInfoDTO.setStartRow(pageInfo.getStartRow());
        pageInfoDTO.setEndRow(pageInfo.getEndRow());
        pageInfoDTO.setPages(pageInfo.getPages());
        pageInfoDTO.setPrePage(pageInfo.getPrePage());
        pageInfoDTO.setNextPage(pageInfo.getNextPage());
        pageInfoDTO.setFirstPage(pageInfo.isIsFirstPage());
        pageInfoDTO.setLastPage(pageInfo.isIsLastPage());
        pageInfoDTO.setHasPreviousPage(pageInfo.isHasPreviousPage());
        pageInfoDTO.setHasNextPage(pageInfo.isHasNextPage());
        pageInfoDTO.setNavigateFirstPage(pageInfo.getNavigateFirstPage());
        pageInfoDTO.setNavigateLastPage(pageInfo.getNavigateLastPage());
        pageInfoDTO.setNavigatepageNums(pageInfo.getNavigatepageNums());
        pageInfoDTO.setNavigatePages(pageInfo.getNextPage());
        FullPageResultDTO pageResultDTO = new FullPageResultDTO(pageInfo.getList(),pageInfoDTO);
        return pageResultDTO;
    }
}
