package net.quanter.shield.mybatis.codegen;

import com.baomidou.mybatisplus.core.toolkit.StringPool;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.*;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.FileType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.VelocityTemplateEngine;
import net.quanter.shield.mybatis.base.BaseMapper;
import net.quanter.shield.mybatis.base.Entity;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class CodeTools  {

    private static final String AUTHOR = "AutoGenerator";

    /**
     * 单数据源方案
     * @param isNew 是否新表（含有Entity里的五个规范字段）
     * @param tableNames 表名
     * @throws Exception 异常
     */
    public static void genSimpleDataSource(boolean isNew,boolean fileOverride,String ... tableNames) throws Exception {
        // 代码生成器
        AutoGenerator mpg = new AutoGenerator();
        ClassLoader classLoader = CodeTools.class.getClassLoader();
        String filePath = "bootstrap.properties";
        URL url = classLoader.getResource(filePath);
        Properties properties = new Properties();
        properties.load(new FileInputStream(url.getFile()));
        File file = new File(url.toURI());

        while (file != null && !"target".equalsIgnoreCase(file.getName())) {
            file = file.getParentFile();
        }

        String projectPath = file.getParentFile().getPath();
        System.out.println(file.getPath());
        GlobalConfig gc = new GlobalConfig();
        gc.setOutputDir(projectPath + "/src/main/java");
        gc.setAuthor(AUTHOR);
        gc.setBaseResultMap(true);
        gc.setBaseColumnList(isNew);
        gc.setOpen(false);
        gc.setSwagger2(true);
        gc.setFileOverride(fileOverride);
        mpg.setGlobalConfig(gc);

        // 数据源配置
        DataSourceConfig dsc = new DataSourceConfig();
        String jdbcUrl = properties.getProperty("spring.datasource.url");
        dsc.setUrl(jdbcUrl);
        dsc.setDriverName(properties.getProperty("spring.datasource.driver-class-name", "com.mysql.jdbc.Driver"));
        dsc.setUsername(properties.getProperty("spring.datasource.username"));
        dsc.setPassword(properties.getProperty("spring.datasource.password"));
        mpg.setDataSource(dsc);

        String[] s1 = jdbcUrl.split("[?]");

        String dataBaseSingle = null;
        if(s1!=null && s1.length>0){
            String[] s2 = s1[0].split("/");
            if(s2!=null && s2.length>0){
                dataBaseSingle = s2[s2.length-1];
            }
        }
        if(dataBaseSingle==null){
            return;
        }

        final String database = dataBaseSingle;

        // 包配置
        PackageConfig pc = new PackageConfig();
        pc.setModuleName("");
        String packageParent = "com.duobaoyu."+properties.getProperty("spring.application.name");
        String mapperPackageInfo = packageParent + ".mapper." + database;
        pc.setParent(packageParent);
        mpg.setPackageInfo(pc);

        // 自定义配置
        InjectionConfig cfg = new InjectionConfig() {
            @Override
            public void initMap() {
                // to do nothing
            }
        };

//        String templatePath = "/templates/defaultmapping.xml.vm";

        List<FileOutConfig> focList = new ArrayList<>();
        focList.add(new FileOutConfig("templates/defaultmapping.xml.vm") {
            @Override
            public String outputFile(TableInfo tableInfo) {
                // 自定义输出文件名 ， 如果你 Entity 设置了前后缀、此处注意 xml 的名称会跟着发生变化！！
                return projectPath + "/src/main/resources/mapper/" + database + "/" + tableInfo.getEntityName() + "Mapper" + StringPool.DOT_XML;
            }
        });
        cfg.setFileCreate(new IFileCreate() {
            @Override
            public boolean isCreate(ConfigBuilder configBuilder, FileType fileType, String filePath) {
                // 判断自定义文件夹是否需要创建
                checkDir(filePath);
                if (fileType.equals(FileType.OTHER)) {
                    if(!configBuilder.getPathInfo().containsKey("rePath")){
                        Map<String, String> pathInfo = configBuilder.getPathInfo();
                        String newPathInfo = pathInfo.get("mapper_path") + File.separator + database;
                        pathInfo.put("mapper_path", newPathInfo);
                        Map<String, String> packageInfo = configBuilder.getPackageInfo();
                        String newPackageInfo = packageInfo.get("Mapper") + "." + database;
                        packageInfo.put("Mapper", newPackageInfo);
                        configBuilder.getPathInfo().put("rePath","true");
                    }
                }
                if (fileType.equals(FileType.CONTROLLER) || fileType.equals(FileType.SERVICE) || fileType.equals(FileType.SERVICE_IMPL)){
                    return false;
                }
                else {
                    return true;
                }
            }
        });
        cfg.setFileOutConfigList(focList);
        mpg.setCfg(cfg);

        TemplateConfig templateConfig = new TemplateConfig();
        //指定自定义模板路径，注意不要带上.ftl/.vm, 会根据使用的模板引擎自动识别
        templateConfig.setMapper("templates/defaultmapper.java.vm");

        templateConfig.setXml(null);
        mpg.setTemplate(templateConfig);

        // 策略配置
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setSuperEntityClass(Entity.class.getName());
        strategy.setSuperMapperClass(BaseMapper.class.getName());
        strategy.setEntityLombokModel(true);
        strategy.setInclude(tableNames);
        strategy.setSuperEntityColumns("created_time", "created_by", "updated_time", "updated_by", "is_deleted");
        strategy.setControllerMappingHyphenStyle(true);
        strategy.setTablePrefix(pc.getModuleName() + "_");
        strategy.setLogicDeleteFieldName("is_deleted");
        strategy.setEntityTableFieldAnnotationEnable(true);
        mpg.setStrategy(strategy);
        mpg.setTemplateEngine(new VelocityTemplateEngine());
        mpg.execute();
    }

    /**
     * 多数据源方案
     *
     * @param isNew 是否新表（含有Entity里的五个规范字段）
     * @param database   数据库名
     * @param tableNames 表名
     * @throws Exception 异常
     */
    public static void genMultiDataSource(boolean isNew,boolean fileOverride, String database, String...tableNames) throws Exception {
        // 代码生成器
        AutoGenerator mpg = new AutoGenerator();
        ClassLoader classLoader = CodeTools.class.getClassLoader();
        String filePath = "bootstrap.properties";
        URL url = classLoader.getResource(filePath);
        Properties properties = new Properties();
        properties.load(new FileInputStream(url.getFile()));
        File file = new File(url.toURI());

        while (file != null && !"target".equalsIgnoreCase(file.getName())) {
            file = file.getParentFile();
        }

        String projectPath = file.getParentFile().getPath();
        GlobalConfig gc = new GlobalConfig();
        gc.setOutputDir(projectPath + "/src/main/java");
        gc.setAuthor(AUTHOR);
        gc.setBaseResultMap(true);
        gc.setBaseColumnList(isNew);
        gc.setOpen(false);
        gc.setSwagger2(true);
        gc.setFileOverride(fileOverride);
        mpg.setGlobalConfig(gc);

        // 数据源配置
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setUrl(properties.getProperty("spring.datasource.url." + database));
        dsc.setDriverName(properties.getProperty("spring.datasource.driver-class-name." + database, "com.mysql.jdbc.Driver"));
        dsc.setUsername(properties.getProperty("spring.datasource.username." + database));
        dsc.setPassword(properties.getProperty("spring.datasource.password." + database));
        mpg.setDataSource(dsc);

        // 包配置
        PackageConfig pc = new PackageConfig();
        pc.setModuleName("");
        String packageParent = "com.duobaoyu."+properties.getProperty("spring.application.name");
        String mapperPackageInfo = packageParent + ".mapper." + database;
        pc.setParent(packageParent);
        mpg.setPackageInfo(pc);

        // 自定义配置
        InjectionConfig cfg = new InjectionConfig() {
            @Override
            public void initMap() {
                // to do nothing
            }
        };

//        String templatePath = "/templates/defaultmapping.xml.vm";

        List<FileOutConfig> focList = new ArrayList<>();
        focList.add(new FileOutConfig("templates/defaultmapping.xml.vm") {
            @Override
            public String outputFile(TableInfo tableInfo) {
                // 自定义输出文件名 ， 如果你 Entity 设置了前后缀、此处注意 xml 的名称会跟着发生变化！！
                return projectPath + "/src/main/resources/mapper/" + database + "/" + tableInfo.getEntityName() + "Mapper" + StringPool.DOT_XML;
            }
        });

        cfg.setFileCreate(new IFileCreate() {
            @Override
            public boolean isCreate(ConfigBuilder configBuilder, FileType fileType, String filePath) {
                // 判断自定义文件夹是否需要创建
                checkDir(filePath);
                if (fileType.equals(FileType.OTHER)) {
                    if(!configBuilder.getPathInfo().containsKey("rePath")){
                        Map<String, String> pathInfo = configBuilder.getPathInfo();
                        String newPathInfo = pathInfo.get("mapper_path") + File.separator + database;
                        pathInfo.put("mapper_path", newPathInfo);
                        Map<String, String> packageInfo = configBuilder.getPackageInfo();
                        String newPackageInfo = packageInfo.get("Mapper") + "." + database;
                        packageInfo.put("Mapper", newPackageInfo);
                        configBuilder.getPathInfo().put("rePath","true");
                    }
                }
                if (fileType.equals(FileType.CONTROLLER) || fileType.equals(FileType.SERVICE) || fileType.equals(FileType.SERVICE_IMPL)){
                    return false;
                }
                else {
                    return true;
                }
            }
        });
        cfg.setFileOutConfigList(focList);
        mpg.setCfg(cfg);

        TemplateConfig templateConfig = new TemplateConfig();
        //指定自定义模板路径，注意不要带上.ftl/.vm, 会根据使用的模板引擎自动识别
        templateConfig.setMapper("templates/defaultmapper.java.vm");

        templateConfig.setXml(null);
        mpg.setTemplate(templateConfig);

        // 策略配置
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setSuperEntityClass(Entity.class.getName());
        strategy.setSuperMapperClass(BaseMapper.class.getName());
        strategy.setEntityLombokModel(true);
        strategy.setInclude(tableNames);
        strategy.setSuperEntityColumns("created_time", "created_by", "updated_time", "updated_by", "is_deleted");
        strategy.setControllerMappingHyphenStyle(true);
        strategy.setTablePrefix(pc.getModuleName() + "_");
        strategy.setLogicDeleteFieldName("is_deleted");
        strategy.setEntityTableFieldAnnotationEnable(true);
        mpg.setStrategy(strategy);
        mpg.setTemplateEngine(new VelocityTemplateEngine());
        mpg.execute();
    }
}
