package net.quanter.shield.mybatis.base;

import java.io.Serializable;
import java.util.List;

public interface BaseMapper<T extends Entity> {
    int insert(T entity);
    int insertList(List<T> list);
    int updateById(T entity);
    int updateByIdSelective(T entity);
    int deleteBatchIds(List<? extends Serializable> idList);
    T selectById(Serializable id);
    List<T> selectBatchIds(List<? extends Serializable> idList);
    List<T> select(T entity);
}