/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.mybatis.page;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.ISelect;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.quanter.shield.common.dto.result.page.FullPageInfoDTO;
import net.quanter.shield.common.dto.result.page.ListFullPageResultDTO;
import net.quanter.shield.common.dto.result.page.ListPageResultDTO;
import net.quanter.shield.common.dto.result.page.PageDTO;
import net.quanter.shield.common.dto.result.page.PageInfoDTO;

public class PageUtil {
    private static final ThreadLocal<Map<String, PageDTO>> THREAD_MAP = new ThreadLocal();
    private static final String DEFAULT_THREAD_NAME = PageUtil.class.getName();
    public static final PageDTO DEFAULT_PAGE_DTO = new PageDTO(Integer.valueOf(10));

    public static void set(Integer pageNum, Integer pageSize) {
        PageDTO page = new PageDTO(pageNum, pageSize);
        PageUtil.set(DEFAULT_THREAD_NAME, page);
    }

    public static void set(String name, Integer pageNum, Integer pageSize) {
        PageDTO page = new PageDTO(pageNum, pageSize);
        PageUtil.set(name, page);
    }

    public static void set(String name, PageDTO page) {
        Map<String, PageDTO> map = THREAD_MAP.get();
        if (map == null || !map.containsKey(name)) {
            map = new HashMap<String, PageDTO>(8);
        }
        map.put(name, page);
        THREAD_MAP.set(map);
    }

    public static PageDTO get() {
        return PageUtil.get(DEFAULT_THREAD_NAME);
    }

    public static PageDTO get(String name) {
        if (THREAD_MAP.get() == null) {
            return null;
        }
        Map<String, PageDTO> map = THREAD_MAP.get();
        if (map == null || !map.containsKey(name)) {
            return null;
        }
        return map.get(name);
    }

    public static <T> Page<T> getPage() {
        return PageUtil.getPage(DEFAULT_THREAD_NAME);
    }

    public static <T> Page<T> getPage(String name) {
        if (THREAD_MAP.get() == null) {
            return new Page((long)DEFAULT_PAGE_DTO.getStartRow().intValue(), (long)DEFAULT_PAGE_DTO.getPageSize().intValue());
        }
        Map<String, PageDTO> map = THREAD_MAP.get();
        if (map == null || !map.containsKey(name)) {
            return new Page((long)DEFAULT_PAGE_DTO.getStartRow().intValue(), (long)DEFAULT_PAGE_DTO.getPageSize().intValue());
        }
        PageDTO pageDTO = map.get(name);
        return new Page((long)pageDTO.getPageNum().intValue(), (long)pageDTO.getPageSize().intValue());
    }

    public static void remove() {
        if (THREAD_MAP.get() != null) {
            THREAD_MAP.get().clear();
            THREAD_MAP.remove();
        }
    }

    public static <T extends Serializable> ListPageResultDTO<T> doSelectInfo(ISelect select) {
        PageDTO pageDTO = PageUtil.get();
        if (pageDTO == null) {
            pageDTO = DEFAULT_PAGE_DTO;
        }
        PageInfo pageInfo = PageHelper.startPage((int)pageDTO.getPageNum(), (int)pageDTO.getPageSize(), (boolean)true, (Boolean)pageDTO.getReasonable(), (Boolean)pageDTO.getPageSizeZero()).doSelectPageInfo(select);
        return PageUtil.create(pageInfo);
    }

    public static <T extends Serializable> ListFullPageResultDTO<T> doSelectInfoFull(ISelect select) {
        PageDTO pageDTO = PageUtil.get();
        if (pageDTO == null) {
            pageDTO = DEFAULT_PAGE_DTO;
        }
        PageInfo pageInfo = PageHelper.startPage((int)pageDTO.getPageNum(), (int)pageDTO.getPageSize(), (boolean)true, (Boolean)pageDTO.getReasonable(), (Boolean)pageDTO.getPageSizeZero()).doSelectPageInfo(select);
        return PageUtil.createFull(pageInfo);
    }

    protected static <T extends Serializable> ListPageResultDTO<T> create(PageInfo<T> pageInfo) {
        PageInfoDTO pageInfoDTO = new PageInfoDTO();
        pageInfoDTO.setPageNum(Integer.valueOf(pageInfo.getPageNum()));
        pageInfoDTO.setPageSize(Integer.valueOf(pageInfo.getPageSize()));
        pageInfoDTO.setTotal(Long.valueOf(pageInfo.getTotal()));
        return new ListPageResultDTO(pageInfo.getList(), pageInfoDTO);
    }

    protected static <T extends Serializable> ListFullPageResultDTO<T> createFull(PageInfo<T> pageInfo) {
        FullPageInfoDTO pageInfoDTO = new FullPageInfoDTO();
        pageInfoDTO.setStartRow(Long.valueOf(pageInfo.getStartRow()));
        pageInfoDTO.setPageSize(Integer.valueOf(pageInfo.getPageSize()));
        pageInfoDTO.setTotal(Long.valueOf(pageInfo.getTotal()));
        pageInfoDTO.setSize(Integer.valueOf(pageInfo.getSize()));
        pageInfoDTO.setStartRow(Long.valueOf(pageInfo.getStartRow()));
        pageInfoDTO.setEndRow(Long.valueOf(pageInfo.getEndRow()));
        pageInfoDTO.setPages(Integer.valueOf(pageInfo.getPages()));
        pageInfoDTO.setPrePage(Integer.valueOf(pageInfo.getPrePage()));
        pageInfoDTO.setNextPage(Integer.valueOf(pageInfo.getNextPage()));
        pageInfoDTO.setFirstPage(pageInfo.isIsFirstPage());
        pageInfoDTO.setLastPage(pageInfo.isIsLastPage());
        pageInfoDTO.setHasPreviousPage(pageInfo.isHasPreviousPage());
        pageInfoDTO.setHasNextPage(pageInfo.isHasNextPage());
        pageInfoDTO.setNavigateFirstPage(Integer.valueOf(pageInfo.getNavigateFirstPage()));
        pageInfoDTO.setNavigateLastPage(Integer.valueOf(pageInfo.getNavigateLastPage()));
        pageInfoDTO.setNavigatepageNums(pageInfo.getNavigatepageNums());
        pageInfoDTO.setNavigatePages(Integer.valueOf(pageInfo.getNextPage()));
        return new ListFullPageResultDTO(pageInfo.getList(), pageInfoDTO);
    }

    public static <T extends Serializable> ListPageResultDTO<T> getListPageResult(IPage<T> page) {
        PageInfoDTO pageInfoDTO = new PageInfoDTO();
        pageInfoDTO.setPageNum(Integer.valueOf((int)page.getCurrent()));
        pageInfoDTO.setPageSize(Integer.valueOf((int)page.getSize()));
        pageInfoDTO.setTotal(Long.valueOf(page.getTotal()));
        return new ListPageResultDTO(page.getRecords(), pageInfoDTO);
    }
}

