/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.dubbo.filter;

import cn.hutool.core.collection.CollectionUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.quanter.shield.common.dto.context.InvocationContextDTO;
import net.quanter.shield.common.dto.context.InvocationDTO;
import net.quanter.shield.common.enums.context.InvocationType;
import net.quanter.shield.utils.bean.BeanUtils;
import net.quanter.shield.utils.invocation.InvocationUtil;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboDebugConsumerFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DubboDebugConsumerFilter.class);
    private AtomicInteger counter = new AtomicInteger(0);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        InvocationContextDTO contextDTO = InvocationUtil.getContext();
        InvocationDTO invocationDTO = null;
        if (contextDTO != null) {
            invocationDTO = new InvocationDTO();
            invocationDTO.setIndex(contextDTO.addAndGet(1));
            invocationDTO.setServiceName(invocation.getServiceName());
            invocationDTO.setMethodName(invocation.getMethodName());
            invocationDTO.setArgs(BeanUtils.clones((Object[])invocation.getArguments()));
            invocationDTO.setType(InvocationType.DUBBO);
            invocation.setAttachment("DubboContextDTO", (Object)contextDTO);
        }
        long begin = System.currentTimeMillis();
        if (contextDTO == null) {
            return invoker.invoke(invocation);
        }
        Result result = null;
        try {
            result = invoker.invoke(invocation);
        }
        catch (Throwable e) {
            invocationDTO.setE(e);
        }
        if (contextDTO != null) {
            List chain;
            invocationDTO.setRt(Long.valueOf(System.currentTimeMillis() - begin));
            if (result != null && result.getValue() != null) {
                Object resultValue = result.getValue();
                invocationDTO.setResult(BeanUtils.clone((Object)resultValue));
            }
            if (CollectionUtil.isNotEmpty((Collection)(chain = (List)result.getObjectAttachment("dubboChain")))) {
                invocationDTO.setChain(chain);
                Integer maxIndex = chain.stream().map(InvocationDTO::getIndex).max(Integer::compareTo).get();
                contextDTO.setAndGet(maxIndex.intValue());
            }
            InvocationUtil.add((InvocationDTO)invocationDTO);
        }
        return result;
    }
}

