package net.quanter.shield.common.util;

/**
 * @author: harley-dog
 */
public enum  Period {
    m1(60,"1分钟"),
    m5(300,"5分钟"),
    m15(900,"15分钟"),
    m30(1800,"半小时"),
    h1(3600,"1小时"),
    h4(14400,"4小时"),
    daily(86400,"1天"),
    week(86400*7,"1周"),
    month(86400*30,"个月");
    public final int seconds;//秒数
    public final String desc;//描述
    Period(int seconds,String desc){
        this.seconds = seconds;
        this.desc = desc;
    }

    public static final Period contain(String name){
        for(Period period:Period.values()){
            if(period.toString().equalsIgnoreCase(name)){
                return period;
            }
        }
        return null;
    }
}
