package net.quanter.shield.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/**
 * 带有调试信息的dto
 * 2019-06-14 09:33
 * @author: harley-dog
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("扩展信息")
public class DebugInfoDto {

    @ApiModelProperty("运行环境")
    protected String env;

    @ApiModelProperty("API版本号")
    protected String version;

    @ApiModelProperty("API名称")
    protected String apiName;

    @ApiModelProperty("API调用方法签名")
    protected String signature;

    @ApiModelProperty("调用链")
    private List<DebugInfoDto> links;

    @ApiModelProperty("标签")
    private Set<String> tagSet = new HashSet<>();

    protected String getTags(){
        return String.join(",",tagSet);
    }

    public DebugInfoDto addLink(DebugInfoDto ex){
        if(links==null){
            links = new LinkedList<>();
            ((LinkedList)links).addLast(ex);
        }
        return this;
    }

    public DebugInfoDto addTag(String tag){
        tagSet.add(tag);
        return this;
    }
}
