/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.common.util;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.quanter.shield.common.util.MathUtils;

public class StringUtils {
    public static final char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'Z', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final char[] b = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static Pattern humpPattern = Pattern.compile("[A-Z]");
    private static Pattern linePattern = Pattern.compile("_(\\w)");

    public static final boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static final String genString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = MathUtils.getRandom(a.length);
            sb.append(a[index]);
        }
        return sb.toString();
    }

    public static final String genNumber(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = MathUtils.getRandom(b.length);
            sb.append(b[index]);
        }
        return sb.toString();
    }

    public static final String join(String[] args, String pre, String suf) {
        StringBuffer sb = new StringBuffer(pre);
        for (int i = 0; args != null && i < args.length; ++i) {
            sb.append(args[i]).append(',');
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(suf);
        return sb.toString();
    }

    public static final String join(Collection<String> args, String pre, String suf) {
        StringBuffer sb = new StringBuffer(pre);
        boolean i = false;
        for (String str : args) {
            sb.append(str).append(',');
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(suf);
        return sb.toString();
    }

    public static final int[] stringToIntArray(String str) {
        return StringUtils.stringToIntArray(str, ",");
    }

    public static final int[] stringToIntArray(String str, String split) {
        String[] strarr = str.split(split);
        int[] r = new int[strarr.length];
        for (int i = 0; i < strarr.length; ++i) {
            r[i] = Integer.parseInt(strarr[i].trim());
        }
        return r;
    }

    public static final double[] stringToDoubleArray(String str) {
        return StringUtils.stringToDoubleArray(str, ",");
    }

    public static final double[] stringToDoubleArray(String str, String split) {
        String[] strarr = str.split(split);
        double[] r = new double[strarr.length];
        for (int i = 0; i < strarr.length; ++i) {
            r[i] = Double.parseDouble(strarr[i].trim());
        }
        return r;
    }

    public static final String doubleArrayToString(double[] ds) {
        return StringUtils.doubleArrayToString(ds, ",", "", "");
    }

    public static final String intArrayToString(int[] ds) {
        return StringUtils.intArrayToString(ds, ",", "", "");
    }

    public static final String doubleArrayToString(double[] ds, String split, String pre, String sub) {
        StringBuilder sb = new StringBuilder(pre);
        for (double s : ds) {
            sb.append(String.format("%.2f", s)).append(split);
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(sub);
        return sb.toString();
    }

    public static String humpToLine(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String lineToHump(String str) {
        str = str.toLowerCase();
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static final String intArrayToString(int[] ds, String split, String pre, String sub) {
        StringBuilder sb = new StringBuilder(pre);
        for (int s : ds) {
            sb.append(s).append(split);
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(sub);
        return sb.toString();
    }
}

