/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.common.dto;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.quanter.shield.common.dto.ResultDTO;

public class SetResultDTO<T>
extends ResultDTO<Set> {
    public static final ResultDTO<Set> emptySet = ResultDTO.success().data(new HashSet()).build();

    public SetResultDTO(boolean success, String message, String code, Set<T> data) {
        super(success, message, code, data);
    }

    public static Builder failure() {
        return new Builder(Boolean.FALSE);
    }

    public static Builder success() {
        return new Builder(Boolean.TRUE);
    }

    public void add(T t) {
        if (super.getData() != null) {
            ((Set)super.getData()).add(t);
        }
    }

    public int size() {
        if (super.get() != null) {
            return ((Set)super.getData()).size();
        }
        return 0;
    }

    public void remove(T t) {
        if (super.getData() != null) {
            ((Set)super.getData()).remove(t);
        }
    }

    public void clear() {
        if (super.get() != null) {
            ((Set)super.get()).clear();
        }
    }

    public void foreach(Consumer<? super T> action) {
        if (super.get() != null) {
            ((Set)super.getData()).forEach(action);
        }
    }

    public static class Builder<T>
    extends ResultDTO.Builder<Set<T>> {
        protected Builder(boolean success) {
            super(success);
            this.data = new HashSet();
        }

        @Override
        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder data(Set<T> data) {
            this.data = data;
            return this;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public SetResultDTO build() {
            return new SetResultDTO(this.success, this.message, this.code, (Set)this.data);
        }
    }
}

