/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel(value="\u63a5\u53e3\u7edf\u4e00\u8fd4\u56de\u4fe1\u606f")
public class ResultDTO<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final ResultDTO<Void> SUCCESS = ResultDTO.success().build();
    public static final ResultDTO<Void> FAILURE = ResultDTO.failure().build();
    public static final ResultDTO<Boolean> T = ResultDTO.success().data(true).build();
    public static final ResultDTO<Boolean> F = ResultDTO.success().data(false).build();
    @ApiModelProperty(value="\u662f\u5426\u6210\u529f")
    private boolean success;
    @ApiModelProperty(value="\u9519\u8bef\u4fe1\u606f")
    private String message;
    @ApiModelProperty(value="\u9519\u8bef\u7801")
    private String code;
    @ApiModelProperty(value="\u6570\u636e")
    private T data;

    public ResultDTO() {
    }

    protected ResultDTO(T data) {
        this.success = true;
        this.data = data;
    }

    protected ResultDTO(boolean success, String message, String code, T data) {
        this.success = success;
        this.message = message;
        this.data = data;
        this.code = code;
    }

    protected ResultDTO(ResultDTO<T> result) {
        this.success = result.success;
        this.message = result.message;
        this.data = result.data;
    }

    public T get() {
        return this.data;
    }

    public ResultDTO clone() throws CloneNotSupportedException, ClassCastException {
        return (ResultDTO)super.clone();
    }

    public static Builder success() {
        return new Builder(Boolean.TRUE);
    }

    public static Builder failure() {
        return new Builder(Boolean.FALSE);
    }

    public static Builder failure(String message) {
        return new Builder(Boolean.FALSE);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public static class Builder<T> {
        protected boolean success = true;
        protected String message;
        protected String code;
        protected T data;

        protected Builder(boolean success) {
            this.success = success;
        }

        protected Builder(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder data(T data) {
            this.data = data;
            return this;
        }

        public ResultDTO build() {
            return new ResultDTO<T>(this.success, this.message, this.code, this.data);
        }
    }
}

