/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.common.dto;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.quanter.shield.common.dto.ResultDTO;

public class MapResultDTO<K, V>
extends ResultDTO<Map> {
    public static final MapResultDTO emptyMap = MapResultDTO.success().build();

    public MapResultDTO(boolean success, String message, String code, Map<K, V> data) {
        super(success, message, code, data);
    }

    public static Builder failure() {
        return new Builder(Boolean.FALSE);
    }

    public static Builder success() {
        return new Builder(Boolean.TRUE);
    }

    public void put(K k, V v) {
        if (super.get() != null) {
            ((Map)super.getData()).put(k, v);
        }
    }

    public int size() {
        if (super.get() != null) {
            return ((Map)super.getData()).size();
        }
        return 0;
    }

    public void remove(K k) {
        if (super.getData() != null) {
            ((Map)super.getData()).remove(k);
        }
    }

    public void clear() {
        if (super.get() != null) {
            ((Map)super.get()).clear();
        }
    }

    public void foreach(BiConsumer<? super K, ? super V> action) {
        if (super.get() != null) {
            ((Map)super.getData()).forEach(action);
        }
    }

    public static class Builder<K, V>
    extends ResultDTO.Builder<Map<K, V>> {
        protected Builder(boolean success) {
            super(success);
            this.data = new ConcurrentHashMap();
        }

        @Override
        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder data(Map<K, V> data) {
            this.data = data;
            return this;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public MapResultDTO build() {
            return new MapResultDTO(this.success, this.message, this.code, (Map)this.data);
        }
    }
}

