/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.common.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.quanter.shield.common.dto.ResultDTO;

public class ListResultDTO<T>
extends ResultDTO<List> {
    public static final ResultDTO<List> emptyList = ResultDTO.success().data(new ArrayList()).build();

    public ListResultDTO(boolean success, String message, String code, List<T> data) {
        super(success, message, code, data);
    }

    public static Builder failure() {
        return new Builder(Boolean.FALSE);
    }

    public static Builder success() {
        return new Builder(Boolean.TRUE);
    }

    public void add(T t) {
        if (super.get() != null) {
            ((List)super.getData()).add(t);
        }
    }

    public int size() {
        if (super.get() != null) {
            return ((List)super.getData()).size();
        }
        return 0;
    }

    public void foreach(Consumer<? super T> action) {
        if (super.get() != null) {
            ((List)super.getData()).forEach(action);
        }
    }

    public void clear() {
        if (super.get() != null) {
            ((List)super.get()).clear();
        }
    }

    public static class Builder<T>
    extends ResultDTO.Builder<List<T>> {
        protected Builder(boolean success) {
            super(success);
            this.data = new ArrayList();
        }

        @Override
        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder data(List<T> data) {
            this.data = data;
            return this;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ListResultDTO build() {
            return new ListResultDTO(this.success, this.message, this.code, (List)this.data);
        }
    }
}

