package net.quanter.shield.common.dto;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class SetResultDTO<T> extends ResultDTO<Set> {
    public static final ResultDTO<Set> emptySet = ResultDTO.success().data(new HashSet()).build();

    public SetResultDTO(boolean success, String message, String code, Set<T> data) {
        super(success,message,code,data);
    }

    public static SetResultDTO.Builder failure() {
        return new SetResultDTO.Builder(Boolean.FALSE);
    }

    public static SetResultDTO.Builder success() {
        return new SetResultDTO.Builder(Boolean.TRUE);
    }

    public void add(T t){
        if(super.getData()!=null){
            super.getData().add(t);
        }
    }

    public int size(){
        if(super.get()!=null){
            return super.getData().size();
        }else {
            return 0;
        }
    }

    public void remove(T t){
        if(super.getData()!=null){
            super.getData().remove(t);
        }
    }

    public void clear() {
        if(super.get()!=null){
            super.get().clear();
        }
    }

    public void foreach(Consumer<? super T> action){
        if(super.get()!=null){
            super.getData().forEach(action);
        }
    }

    public static class Builder<T> extends ResultDTO.Builder<Set<T>>{

        protected Builder(boolean success) {
            super(success);
            this.data = new HashSet<>();
        }

        public SetResultDTO.Builder code(String code) {
            this.code = code;
            return this;
        }

        public SetResultDTO.Builder data(Set<T> data) {
            this.data = data;
            return this;
        }

        public SetResultDTO.Builder message(String message) {
            this.message = message;
            return this;
        }

        public SetResultDTO build() {
            return new SetResultDTO(success, message, code, data);
        }
    }
}
