package net.quanter.shield.common.dto;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public class MapResultDTO<K,V> extends ResultDTO<Map> {
    public static final MapResultDTO emptyMap = MapResultDTO.success().build();

    public MapResultDTO(boolean success, String message, String code, Map<K,V> data) {
        super(success,message,code,data);
    }

    public static MapResultDTO.Builder failure() {
        return new MapResultDTO.Builder(Boolean.FALSE);
    }

    public static MapResultDTO.Builder success() {
        return new MapResultDTO.Builder(Boolean.TRUE);
    }

    public void put(K k,V v){
        if(super.get()!=null){
            super.getData().put(k,v);
        }
    }

    public int size(){
        if(super.get()!=null){
            return super.getData().size();
        }else {
            return 0;
        }
    }

    public void remove(K k){
        if(super.getData()!=null){
            super.getData().remove(k);
        }
    }

    public void clear() {
        if(super.get()!=null){
            super.get().clear();
        }
    }

    public void foreach(BiConsumer<? super K, ? super V> action){
        if(super.get()!=null){
            super.getData().forEach(action);
        }
    }

    public static class Builder<K,V> extends ResultDTO.Builder<Map<K,V>>{

        protected Builder(boolean success) {
            super(success);
            this.data = new ConcurrentHashMap<>();
        }

        public MapResultDTO.Builder code(String code) {
            this.code = code;
            return this;
        }

        public MapResultDTO.Builder data(Map<K,V> data) {
            this.data = data;
            return this;
        }

        public MapResultDTO.Builder message(String message) {
            this.message = message;
            return this;
        }

        public MapResultDTO build() {
            return new MapResultDTO(success, message, code, data);
        }
    }
}
