package net.quanter.shield.common.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ListResultDTO<T> extends ResultDTO<List> {
    public static final ResultDTO<List> emptyList = ResultDTO.success().data(new ArrayList()).build();

    public ListResultDTO(boolean success, String message, String code, List<T> data) {
        super(success,message,code,data);
    }

    public static ListResultDTO.Builder failure() {
        return new ListResultDTO.Builder(Boolean.FALSE);
    }

    public static ListResultDTO.Builder success() {
        return new ListResultDTO.Builder(Boolean.TRUE);
    }

    public void add(T t){
        if(super.get()!=null){
            super.getData().add(t);
        }

    }

    public int size(){
        if(super.get()!=null){
            return super.getData().size();
        }else {
            return 0;
        }
    }

    public void foreach(Consumer<? super T>  action){
        if(super.get()!=null){
            super.getData().forEach(action);
        }
    }

    public void clear() {
        if(super.get()!=null){
            super.get().clear();
        }
    }

    public static class Builder<T> extends ResultDTO.Builder<List<T>>{

        protected Builder(boolean success) {
            super(success);
            this.data = new ArrayList<>();
        }

        public ListResultDTO.Builder code(String code) {
            this.code = code;
            return this;
        }

        public ListResultDTO.Builder data(List<T> data) {
            this.data = data;
            return this;
        }

        public ListResultDTO.Builder message(String message) {
            this.message = message;
            return this;
        }

        public ListResultDTO build() {
            return new ListResultDTO(success, message, code, data);
        }
    }
}
