/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.common.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.quanter.shield.common.util.Period;

public class CalendarUtils {
    public static DateFormat dateFormat_US = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
    private static DateFormat dateFormat_standard = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Lock lock_standard = new ReentrantLock();
    private static DateFormat dateFormat_short_standard = new SimpleDateFormat("M-d H:m:s");
    private static Lock lock_short_standard = new ReentrantLock();
    private static DateFormat dateFormat_full = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS E");
    private static Lock lock_full = new ReentrantLock();
    private static DateFormat dateFormat_ms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static Lock lock_ms = new ReentrantLock();
    private static DateFormat dateFormat_simple = new SimpleDateFormat("yyyy-MM-dd");
    private static Lock lock_simple = new ReentrantLock();
    private static DateFormat dateFormat_option = new SimpleDateFormat("yyyyMMdd");
    private static Lock lock_option = new ReentrantLock();
    private static DateFormat dateFormat_Simple_option = new SimpleDateFormat("MMdd");
    private static Lock lock_Simple_option = new ReentrantLock();
    private static DateFormat dateFormat_tight_standard = new SimpleDateFormat("yyyyMMddHHmmss");
    private static Lock lock_tight_standard = new ReentrantLock();
    private static DateFormat dateFormat_tight = new SimpleDateFormat("yyyyMMddHHmm");
    private static Lock lock_tight = new ReentrantLock();
    private static DateFormat gmt_dateFormat_simple = new SimpleDateFormat("yyyyMMdd");
    private static DateFormat gmt_dateFormat_standard = new SimpleDateFormat("yyyyMMddHHmmss");
    private static TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static Lock lock_gmt_dateFormat_simple;
    private static Lock lock_gmt_dateFormat_standard;

    public static String formatStandard(Date date) {
        String s = null;
        lock_standard.lock();
        s = dateFormat_standard.format(date);
        lock_standard.unlock();
        return s;
    }

    public static String formatStandard(long time) {
        String s = null;
        lock_standard.lock();
        s = dateFormat_standard.format(time);
        lock_standard.unlock();
        return s;
    }

    public static Date parseStandard(String str) throws ParseException {
        Date date = null;
        lock_standard.lock();
        date = dateFormat_standard.parse(str);
        lock_standard.unlock();
        return date;
    }

    public static String formatShortStandard(Date date) {
        String s = null;
        lock_short_standard.lock();
        s = dateFormat_short_standard.format(date);
        lock_short_standard.unlock();
        return s;
    }

    public static String formatFull(Date date) {
        String s = null;
        lock_full.lock();
        s = dateFormat_full.format(date);
        lock_full.unlock();
        return s;
    }

    public static String formatFullCurrentDate() {
        return CalendarUtils.formatFull(new Date());
    }

    public static String formatMs(Date date) {
        String s = null;
        lock_ms.lock();
        s = dateFormat_ms.format(date);
        lock_ms.unlock();
        return s;
    }

    public static String formatMsCurrentDate() {
        return CalendarUtils.formatMs(new Date());
    }

    public static String formatSimple(Date date) {
        String s = null;
        lock_simple.lock();
        s = dateFormat_simple.format(date);
        lock_simple.unlock();
        return s;
    }

    public static String formatSimple(long time) {
        String s = null;
        lock_simple.lock();
        s = dateFormat_simple.format(time);
        lock_simple.unlock();
        return s;
    }

    public static Date parseSimple(String str) throws ParseException {
        Date date = null;
        lock_simple.lock();
        date = dateFormat_simple.parse(str);
        lock_simple.unlock();
        return date;
    }

    public static String formatOption(Date date) {
        String s = null;
        lock_option.lock();
        s = dateFormat_option.format(date);
        lock_option.unlock();
        return s;
    }

    public static String formatOption(long time) {
        String s = null;
        lock_option.lock();
        s = dateFormat_option.format(time);
        lock_option.unlock();
        return s;
    }

    public static Date parseOption(String str) throws ParseException {
        Date date = null;
        lock_option.lock();
        date = dateFormat_option.parse(str);
        lock_option.unlock();
        return date;
    }

    public static String formatSimpleOption(Date date) {
        String s = null;
        lock_Simple_option.lock();
        s = dateFormat_Simple_option.format(date);
        lock_Simple_option.unlock();
        return s;
    }

    public static Date parseSimpleOption(String str) throws ParseException {
        Date date = null;
        lock_Simple_option.lock();
        date = dateFormat_Simple_option.parse(str);
        lock_Simple_option.unlock();
        return date;
    }

    public static String formatTightStard(long time) {
        String s = null;
        lock_tight_standard.lock();
        s = dateFormat_tight_standard.format(time);
        lock_tight_standard.unlock();
        return s;
    }

    public static Date parseTightStandard(String str) throws ParseException {
        Date date = null;
        lock_tight_standard.lock();
        date = dateFormat_tight_standard.parse(str);
        lock_tight_standard.unlock();
        return date;
    }

    public static String formatTight(Date date) {
        String s = null;
        lock_tight.lock();
        s = dateFormat_tight.format(date);
        lock_tight.unlock();
        return s;
    }

    public static Date parseTight(String str) throws ParseException {
        Date date = null;
        lock_tight.lock();
        date = dateFormat_tight.parse(str);
        lock_tight.unlock();
        return date;
    }

    public static String formatGMTStandard(Date date) {
        String s = null;
        lock_gmt_dateFormat_standard.lock();
        s = gmt_dateFormat_standard.format(date);
        lock_gmt_dateFormat_standard.unlock();
        return s;
    }

    public static String formatGMTStandard(long time) {
        String s = null;
        lock_gmt_dateFormat_standard.lock();
        s = gmt_dateFormat_standard.format(time);
        lock_gmt_dateFormat_standard.unlock();
        return s;
    }

    public static Date parseGMTStandard(String str) throws ParseException {
        Date date = null;
        lock_gmt_dateFormat_standard.lock();
        date = gmt_dateFormat_standard.parse(str);
        lock_gmt_dateFormat_standard.unlock();
        return date;
    }

    public static String formatGMTSimple(Date date) {
        String s = null;
        lock_gmt_dateFormat_simple.lock();
        s = gmt_dateFormat_simple.format(date);
        lock_gmt_dateFormat_simple.unlock();
        return s;
    }

    public static String formatGMTSimple(long time) {
        String s = null;
        lock_gmt_dateFormat_simple.lock();
        s = gmt_dateFormat_simple.format(time);
        lock_gmt_dateFormat_simple.unlock();
        return s;
    }

    public static Date parseGMTSimple(String str) throws ParseException {
        Date date = null;
        lock_gmt_dateFormat_simple.lock();
        date = gmt_dateFormat_simple.parse(str);
        lock_gmt_dateFormat_simple.unlock();
        return date;
    }

    public static Date getFirstDate(Date date, int field) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getDefault());
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.set(field, 1);
        return c.getTime();
    }

    public static Date getPreEndTime(Date date, Period field) {
        switch (field) {
            case m1: 
            case m5: 
            case m15: 
            case m30: 
            case h1: 
            case h4: {
                return CalendarUtils.getFirstTime(date, field);
            }
        }
        return date;
    }

    public static Date getFirstTime(Date date, Period field) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getDefault());
        c.setTime(date);
        c.set(14, 0);
        c.set(13, 0);
        int minute = c.get(12);
        int hour = c.get(11);
        switch (field) {
            case m1: {
                break;
            }
            case m5: {
                minute -= minute % 5;
                c.set(12, minute);
                break;
            }
            case m15: {
                minute -= minute % 15;
                c.set(12, minute);
                break;
            }
            case m30: {
                minute -= minute % 30;
                c.set(12, minute);
                break;
            }
            case h1: {
                c.set(12, 0);
                break;
            }
            case h4: {
                c.set(12, 0);
                hour -= hour % 4;
                c.set(11, hour);
                break;
            }
            case daily: {
                c.set(12, 0);
                c.set(11, 0);
            }
        }
        return c.getTime();
    }

    public static Date getYestoday() {
        Calendar c = Calendar.getInstance();
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(5, -1);
        return c.getTime();
    }

    public static int getDiff(Date begin, Date end, int field) {
        switch (field) {
            case 14: {
                return (int)(end.getTime() - begin.getTime());
            }
            case 13: {
                return (int)((end.getTime() - begin.getTime()) / 1000L);
            }
            case 12: {
                return (int)((end.getTime() - begin.getTime()) / 60000L);
            }
            case 10: {
                return (int)((end.getTime() - begin.getTime()) / 3600000L);
            }
            case 5: {
                return (int)((end.getTime() - begin.getTime()) / 86400000L);
            }
        }
        return (int)((end.getTime() - begin.getTime()) / 86400000L);
    }

    public static Date addDate(Date date, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(5, days);
        return c.getTime();
    }

    public static Date addDate(int days) {
        Calendar c = Calendar.getInstance();
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(5, days);
        return c.getTime();
    }

    public static String getDateFormat(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(date);
    }

    public static boolean isWeekDay(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        c.setFirstDayOfWeek(1);
        int day_of_week = c.get(7);
        return day_of_week == 1 || day_of_week == 7;
    }

    public static boolean isForexTradingTime(long time) {
        boolean isWeekDay = CalendarUtils.isWeekDay(time);
        if (isWeekDay) {
            return false;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        int day_of_week = c.get(7);
        int hour_of_day = c.get(11);
        int minute = c.get(12);
        if (day_of_week == 2) {
            if (hour_of_day >= 1 && hour_of_day <= 22) {
                return true;
            }
            if (hour_of_day == 23 && minute < 30) {
                return true;
            }
        } else {
            if (day_of_week >= 3 && day_of_week <= 5) {
                if (hour_of_day >= 1 && hour_of_day <= 22) {
                    return true;
                }
                if (hour_of_day == 0 && minute >= 30) {
                    return true;
                }
                if (hour_of_day == 23 && minute < 30) {
                    return true;
                }
                return true;
            }
            if (day_of_week == 6) {
                if (hour_of_day >= 1 && hour_of_day <= 22) {
                    return true;
                }
                if (hour_of_day == 0 && minute >= 30) {
                    return true;
                }
            }
        }
        return false;
    }

    public static Date getLastWorkDayByThisMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.add(5, 1 - calendar.get(7) - 2);
        Date result = calendar.getTime();
        return result;
    }

    public static void main(String[] args) throws ParseException {
        Date date = new Date();
        Date d = CalendarUtils.getFirstDate(date, 7);
        System.out.println(d);
        Date yes = CalendarUtils.getYestoday();
        System.out.println(yes);
        SimpleDateFormat dateFormat_cn = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
        Date d2000 = dateFormat_cn.parse("2000-01-01");
        System.out.println(d2000 + ":" + d2000.getTime());
    }

    static {
        gmt_dateFormat_simple.setTimeZone(GMT);
        gmt_dateFormat_standard.setTimeZone(GMT);
        lock_gmt_dateFormat_simple = new ReentrantLock();
        lock_gmt_dateFormat_standard = new ReentrantLock();
    }
}

