package net.quanter.shield.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.io.Serializable;

/**
 * shield-common
 * 统一返回对象
 * create: 2019-06-14 09:33
 * @author: harley-dog
 *
 */
public class ResultDTO<T extends Object> implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;
    public static final ResultDTO SUCCESDS = ResultDTO.success().build();
    public static final ResultDTO FAILURE = ResultDTO.failure().build();

    @ApiModelProperty("是否成功")
    @Getter private boolean success;

    @ApiModelProperty("错误信息")
    @Getter private String message;

    @ApiModelProperty("错误码")
    @Getter private String code;

    @ApiModelProperty("返回结果")
    @Getter private T data;

    public ResultDTO(){
    }

    protected ResultDTO(T data) {
        this.success = true;
        this.data = data;
    }

    protected ResultDTO(boolean success, String message, String code, T data) {
        this.success = success;
        this.message = message;
        this.data = data;
        this.code = code;
    }

    protected ResultDTO(ResultDTO<T> result) {
        this.success = result.isSuccess();
        this.message = result.getMessage();
        this.data = result.getData();
    }

    public T get() {
        return data;
    }

    @Override
    public ResultDTO clone() throws CloneNotSupportedException,ClassCastException {
        return (ResultDTO)super.clone();
    }

    public static Builder success() {
        return new Builder(Boolean.TRUE);
    }

    public static Builder failure() {
        return new Builder(Boolean.FALSE);
    }

    public static class Builder<T extends Object> {

        protected boolean success = true;

        protected String message;

        protected String code;

        protected T data;

        public Builder(boolean success) {
            this.success = success;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder data(T data) {
            this.data = data;
            return this;
        }

        public ResultDTO build() {
            return new ResultDTO(success, message, code,data);
        }
    }
}
