/*
 * Decompiled with CFR 0.152.
 */
package net.qdevzone.docunit.struct;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import net.qdevzone.docunit.AbstractDocAssert;
import net.qdevzone.docunit.DocumentAssert;
import org.assertj.core.api.Assertions;
import org.w3c.dom.Document;

public class XmlAssertions
extends AbstractDocAssert<XmlAssertions> {
    private final Document document;
    private final DocumentAssert base;
    private Throwable loadError;

    public XmlAssertions(DocumentAssert base) {
        super(XmlAssertions.class);
        this.document = this.parseXml(base.actual());
        this.base = base;
    }

    private Document parseXml(byte[] data) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(data));
        }
        catch (Exception e) {
            this.loadError = e;
            return null;
        }
    }

    public XmlAssertions hasXPath(String expression, String expectedValue) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile(expression);
            String result = expr.evaluate(this.document).trim();
            if (!expectedValue.equals(result)) {
                throw this.failure("xpath '%s' expected <%s>, got <%s>.", expression, expectedValue, result);
            }
        }
        catch (Exception e) {
            throw this.failure("error in xpath expression '%s': %s", expression, e.getMessage());
        }
        return this;
    }

    public XmlAssertions hasRootElement(String expectedName) {
        String actual = this.document.getDocumentElement().getTagName();
        if (!expectedName.equals(actual)) {
            throw this.failure("expected root element <%s> does not match <%s>.", expectedName, actual);
        }
        return this;
    }

    @Override
    public XmlAssertions isValid() {
        if (this.loadError != null) {
            throw this.failure("unloadable document: %s", this.loadError.getMessage());
        }
        if (this.document == null) {
            throw this.failure("document loader returned null", new Object[0]);
        }
        return this;
    }

    @Override
    public XmlAssertions isNotValid() {
        if (this.loadError == null && this.document != null) {
            throw this.failure("document was valid", new Object[0]);
        }
        return this;
    }

    public XmlAssertions contains(CharSequence ... expected) {
        String fullText = this.document.getDocumentElement().getTextContent();
        Assertions.assertThat((String)fullText).contains(expected);
        return this;
    }

    @Override
    public byte[] actual() {
        return this.base.actual();
    }
}

