/*
 * Decompiled with CFR 0.152.
 */
package net.qdevzone.docunit.struct;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import net.qdevzone.docunit.AbstractDocAssert;
import net.qdevzone.docunit.DocumentAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;

public class JSONAssertions
extends AbstractDocAssert<JSONAssertions> {
    private final String document;
    private final DocumentAssert base;
    private static final Class<?>[] PLAIN_VALUE_CLASSES = new Class[]{String.class, Integer.class, Long.class, Boolean.class};

    public JSONAssertions(DocumentAssert base) {
        super(JSONAssertions.class);
        this.document = base.actual() != null ? new String(base.actual()) : null;
        this.base = base;
    }

    @Override
    public JSONAssertions isValid() {
        if (this.document == null) {
            throw this.failure("document is null", new Object[0]);
        }
        JsonPath.parse((InputStream)this.createInputStream());
        try {
            new ObjectMapper().readTree(this.base.actual());
        }
        catch (IOException e) {
            throw this.failureWithCause(e, "Input is not valid JSON: %s", e.getMessage());
        }
        return this;
    }

    @Override
    public JSONAssertions isNotValid() {
        if (this.document != null) {
            throw this.failure("document was valid", new Object[0]);
        }
        return this;
    }

    public JSONAssertions contains(CharSequence ... expected) {
        Assertions.assertThat((String)this.document).contains(expected);
        return this;
    }

    public JSONAssertions hasKey(String jsonPath) {
        try {
            Object value = JsonPath.read((InputStream)this.createInputStream(), (String)jsonPath, (Predicate[])new Predicate[0]);
            if (value == null) {
                throw this.failure("JsonPath '%s' does not exist or is null", jsonPath);
            }
        }
        catch (PathNotFoundException e) {
            throw this.failureWithCause(e, "JsonPath '%s' not found", jsonPath);
        }
        catch (IOException e) {
            throw this.failureWithCause(e, e.getMessage(), new Object[0]);
        }
        return this;
    }

    private boolean isPlainValue(Class<?> type) {
        return Lists.list((Object[])PLAIN_VALUE_CLASSES).contains(type);
    }

    public JSONAssertions hasValue(String jsonPath, Object expected) {
        try {
            Object actual = JsonPath.read((InputStream)this.createInputStream(), (String)jsonPath, (Predicate[])new Predicate[0]);
            if (expected != null && !this.isPlainValue(expected.getClass())) {
                String expectedJson = new ObjectMapper().writeValueAsString(expected);
                expected = JsonPath.read((String)expectedJson, (String)"$", (Predicate[])new Predicate[0]);
            }
            if (!Objects.equals(actual, expected)) {
                throw this.failure("JsonPath '%s' expected <%s>, but was <%s>", jsonPath, expected, actual);
            }
        }
        catch (PathNotFoundException e) {
            throw this.failure("JsonPath '%s' not found: %s", jsonPath, e.getMessage());
        }
        catch (IOException e) {
            throw this.failure(e.getMessage(), new Object[0]);
        }
        return this;
    }

    public JSONAssertions hasArraySize(String jsonPath, int expectedSize) {
        try {
            List array = (List)JsonPath.read((InputStream)this.createInputStream(), (String)jsonPath, (Predicate[])new Predicate[0]);
            if (array.size() != expectedSize) {
                throw this.failure("JsonPath '%s' has %d elements, expected: %d", jsonPath, array.size(), expectedSize);
            }
        }
        catch (ClassCastException e) {
            throw this.failure("JsonPath '%s' is not an arary", jsonPath);
        }
        catch (PathNotFoundException e) {
            throw this.failureWithCause(e, "JsonPath '%s' not found", jsonPath);
        }
        catch (IOException e) {
            throw this.failureWithCause(e, e.getMessage(), new Object[0]);
        }
        return this;
    }

    @Override
    public byte[] actual() {
        return this.base.actual();
    }
}

