/*
 * Decompiled with CFR 0.152.
 */
package net.qdevzone.docunit.struct;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.qdevzone.docunit.AbstractDocAssert;
import net.qdevzone.docunit.DocumentAssert;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.assertj.core.api.Assertions;

public class CSVAssertions
extends AbstractDocAssert<CSVAssertions> {
    private final String document;
    private final DocumentAssert base;
    private List<CSVRecord> records;
    private List<String> headers;
    private CSVFormat format;
    private Throwable loadError;
    private String delimiter;

    public CSVAssertions(DocumentAssert base, String delimiter, boolean hasHeaders) {
        this(base, delimiter, hasHeaders, StandardCharsets.UTF_8);
    }

    public CSVAssertions(DocumentAssert base, String delimiter, boolean hasHeaders, Charset charSet) {
        super(CSVAssertions.class);
        this.document = base.actual() != null ? new String(base.actual()) : null;
        this.base = base;
        this.delimiter = delimiter;
        if (base.actual() == null) {
            return;
        }
        try {
            InputStreamReader in = new InputStreamReader((InputStream)this.createInputStream(), charSet);
            this.format = hasHeaders ? CSVFormat.Builder.create().setIgnoreEmptyLines(true).setDelimiter(delimiter).setHeader(new String[0]).setSkipHeaderRecord(true).setAllowMissingColumnNames(true).get() : CSVFormat.Builder.create().setIgnoreEmptyLines(true).setDelimiter(delimiter).get();
            CSVParser parsed = this.format.parse((Reader)in);
            this.records = new ArrayList<CSVRecord>();
            parsed.forEach(this.records::add);
            if (hasHeaders) {
                this.headers = parsed.getHeaderNames();
            }
        }
        catch (IOException e) {
            this.loadError = e;
        }
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public CSVAssertions isValid() {
        if (this.loadError != null) {
            throw this.failure("unloadable document: %s", this.loadError.getMessage());
        }
        if (this.document == null) {
            throw this.failure("document loader returned null", new Object[0]);
        }
        return this;
    }

    @Override
    public CSVAssertions isNotValid() {
        if (this.loadError == null && this.document != null) {
            throw this.failure("document was valid", new Object[0]);
        }
        return this;
    }

    public CSVAssertions contains(CharSequence ... expected) {
        Assertions.assertThat((String)this.document).contains(expected);
        return this;
    }

    public CSVAssertions hasRowCount(int expected) {
        if (this.records.size() != expected) {
            throw this.failure("Expected %d rows but found %d", expected, this.records.size());
        }
        return this;
    }

    public CSVRowAssertions row(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.records.size()) {
            throw this.failure("Row index %d is out of bounds (0..%d)", rowIndex, this.records.size() - 1);
        }
        return new CSVRowAssertions(this.records.get(rowIndex));
    }

    public CSVAssertions hasHeader(String ... expectedHeaders) {
        String[] stringArray = expectedHeaders;
        int n = expectedHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            String h = stringArray[n2];
            if (!this.headers.contains(h)) {
                throw this.failure("Header '%s' not found in CSV (actual: %s)", h, this.headers.toString());
            }
            ++n2;
        }
        return this;
    }

    @Override
    public byte[] actual() {
        return this.base.actual();
    }

    class CSVRowAssertions {
        private final CSVRecord row;

        public CSVRowAssertions(CSVRecord row) {
            this.row = row;
        }

        public CSVRowAssertions hasValue(String columnName, String expectedValue) {
            String actual;
            try {
                actual = this.row.get(columnName);
            }
            catch (IllegalArgumentException ex) {
                throw new AssertionError((Object)("row name error: " + ex.getMessage()));
            }
            if (!expectedValue.equals(actual)) {
                throw new AssertionError((Object)String.format("Expected value in column '%s' to be '%s' but was '%s'", columnName, expectedValue, actual));
            }
            return this;
        }

        public CSVRowAssertions hasValueAt(int columnIndex, String expectedValue) {
            String actual = this.row.get(columnIndex);
            if (!expectedValue.equals(actual)) {
                throw new AssertionError((Object)String.format("Expected value at column %d to be '%s' but was '%s'", columnIndex, expectedValue, actual));
            }
            return this;
        }

        public CSVAssertions and() {
            return CSVAssertions.this;
        }
    }
}

