/*
 * Decompiled with CFR 0.152.
 */
package net.qdevzone.docunit.spreadsheet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.qdevzone.docunit.AbstractDocAssert;
import net.qdevzone.docunit.DocumentAssert;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelAssertions
extends AbstractDocAssert<ExcelAssertions> {
    private final Workbook document;
    private final DocumentAssert base;
    private Throwable loadError;

    public ExcelAssertions(DocumentAssert base) {
        super(ExcelAssertions.class);
        Workbook loadadDoc = null;
        try {
            loadadDoc = WorkbookFactory.create((InputStream)new ByteArrayInputStream(base.actual()));
        }
        catch (IOException | NullPointerException ex) {
            this.loadError = ex;
        }
        this.document = loadadDoc;
        this.base = base;
    }

    @Override
    public ExcelAssertions isValid() {
        if (this.loadError != null) {
            throw this.failure("unloadable document: %s", this.loadError.getMessage());
        }
        if (this.document == null) {
            throw this.failure("document loader returned null", new Object[0]);
        }
        return this;
    }

    @Override
    public ExcelAssertions isNotValid() {
        if (this.loadError == null && this.document != null) {
            throw this.failure("document was valid", new Object[0]);
        }
        return this;
    }

    public ExcelAssertions hasSheetCount(int expected) {
        if (this.document.getNumberOfSheets() != expected) {
            throw this.failure("sheet count %d differs from expected %d", this.document.getNumberOfSheets(), expected);
        }
        return this;
    }

    public ExcelAssertions hasCellValue(int sheetId, int h, int v, String expected) {
        Sheet sheet = this.document.getSheetAt(sheetId);
        String actual = sheet.getRow(v).getCell(v).getStringCellValue();
        if (!actual.equals(expected)) {
            throw this.failure("cell value %s differs from expected %s", actual, expected);
        }
        return this;
    }

    @Override
    public byte[] actual() {
        return this.base.actual();
    }
}

