/*
 * Decompiled with CFR 0.152.
 */
package net.qdevzone.docunit.pdf;

import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPMetaFactory;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.qdevzone.docunit.AbstractDocAssert;
import net.qdevzone.docunit.DocumentAssert;
import net.qdevzone.docunit.PagedDocAsserts;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColorN;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColorSpace;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceCMYKColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceGrayColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceRGBColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColorN;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColorSpace;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceCMYKColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceGrayColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceRGBColor;
import org.apache.pdfbox.contentstream.operator.markedcontent.BeginMarkedContentSequence;
import org.apache.pdfbox.contentstream.operator.markedcontent.BeginMarkedContentSequenceWithProperties;
import org.apache.pdfbox.contentstream.operator.markedcontent.EndMarkedContentSequence;
import org.apache.pdfbox.contentstream.operator.state.Concatenate;
import org.apache.pdfbox.contentstream.operator.state.Restore;
import org.apache.pdfbox.contentstream.operator.state.Save;
import org.apache.pdfbox.contentstream.operator.state.SetFlatness;
import org.apache.pdfbox.contentstream.operator.state.SetGraphicsStateParameters;
import org.apache.pdfbox.contentstream.operator.state.SetLineCapStyle;
import org.apache.pdfbox.contentstream.operator.state.SetLineDashPattern;
import org.apache.pdfbox.contentstream.operator.state.SetLineJoinStyle;
import org.apache.pdfbox.contentstream.operator.state.SetLineMiterLimit;
import org.apache.pdfbox.contentstream.operator.state.SetLineWidth;
import org.apache.pdfbox.contentstream.operator.state.SetMatrix;
import org.apache.pdfbox.contentstream.operator.state.SetRenderingIntent;
import org.apache.pdfbox.contentstream.operator.text.BeginText;
import org.apache.pdfbox.contentstream.operator.text.EndText;
import org.apache.pdfbox.contentstream.operator.text.MoveText;
import org.apache.pdfbox.contentstream.operator.text.MoveTextSetLeading;
import org.apache.pdfbox.contentstream.operator.text.NextLine;
import org.apache.pdfbox.contentstream.operator.text.SetCharSpacing;
import org.apache.pdfbox.contentstream.operator.text.SetFontAndSize;
import org.apache.pdfbox.contentstream.operator.text.SetTextHorizontalScaling;
import org.apache.pdfbox.contentstream.operator.text.SetTextLeading;
import org.apache.pdfbox.contentstream.operator.text.SetTextRenderingMode;
import org.apache.pdfbox.contentstream.operator.text.SetTextRise;
import org.apache.pdfbox.contentstream.operator.text.SetWordSpacing;
import org.apache.pdfbox.contentstream.operator.text.ShowText;
import org.apache.pdfbox.contentstream.operator.text.ShowTextAdjusted;
import org.apache.pdfbox.contentstream.operator.text.ShowTextLine;
import org.apache.pdfbox.contentstream.operator.text.ShowTextLineAndSpace;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.graphics.form.PDTransparencyGroup;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Matrix;

public class PdfAssertions
extends AbstractDocAssert<PdfAssertions>
implements PagedDocAsserts<PdfAssertions> {
    private final PDDocument document;
    private final DocumentAssert base;
    private Throwable loadError;

    private void checkDocumentOK() {
        if (this.document == null) {
            throw new IllegalStateException("document is null");
        }
    }

    private void checkValidPage(int pageNum) {
        if (pageNum < 1 || pageNum > this.document.getNumberOfPages()) {
            throw new IllegalStateException("page number %d out of range (1 ... %d)".formatted(pageNum, this.document.getNumberOfPages()));
        }
    }

    public PdfAssertions(DocumentAssert base) {
        super(PdfAssertions.class);
        PDDocument loadadDoc = null;
        try {
            loadadDoc = Loader.loadPDF((byte[])base.actual());
        }
        catch (IOException | NullPointerException ex) {
            this.loadError = ex;
        }
        this.document = loadadDoc;
        this.base = base;
    }

    @Override
    public PdfAssertions isValid() {
        if (this.loadError != null) {
            throw this.failure("unloadable document: %s", this.loadError.getMessage());
        }
        if (this.document == null) {
            throw this.failure("document loader returned null", new Object[0]);
        }
        return this;
    }

    @Override
    public PdfAssertions isNotValid() {
        if (this.loadError == null && this.document != null) {
            throw this.failure("document was valid", new Object[0]);
        }
        return this;
    }

    @Override
    public byte[] actual() {
        return this.base.actual();
    }

    @Override
    public PdfAssertions hasPages() {
        this.checkDocumentOK();
        if (this.document.getNumberOfPages() == 0) {
            throw this.failure("no pages found", new Object[0]);
        }
        return this;
    }

    @Override
    public PdfAssertions hasPageCount(int count) {
        this.checkDocumentOK();
        int actualPages = this.document.getNumberOfPages();
        if (actualPages != count) {
            throw this.failure("page count %d differs from expected %d", actualPages, count);
        }
        return this;
    }

    @Override
    public PdfAssertions hasPageCount(int min, int max) {
        this.checkDocumentOK();
        int actualPages = this.document.getNumberOfPages();
        if (actualPages < min || actualPages > max) {
            throw this.failure("page count not in range %d >[ %d ]> %d", min, actualPages, max);
        }
        return this;
    }

    public PdfAssertions hasTextInPage(int pageNum, CharSequence search) {
        this.checkDocumentOK();
        PDPage page = this.document.getPage(pageNum - 1);
        Engine pdfEngine = new Engine();
        try {
            pdfEngine.processPage(page);
        }
        catch (IOException e) {
            throw this.failure("page processing error: %s", e.getMessage());
        }
        String pageText = pdfEngine.getContent();
        if (!pageText.contains(search)) {
            throw this.failure("search string '%s' not found", search);
        }
        return this;
    }

    public PdfAssertions hasTextInPage(int pageNum, CharSequence search, Rectangle2D area) {
        this.checkDocumentOK();
        this.checkValidPage(pageNum);
        return this.hasTextInPage(pageNum, search, area, false);
    }

    public PdfAssertions hasTextInPage(int pageNum, CharSequence search, Rectangle2D area, boolean fullyCovertArea) {
        this.checkDocumentOK();
        this.checkValidPage(pageNum);
        PDPage page = this.document.getPage(pageNum - 1);
        Engine pdfEngine = new Engine();
        try {
            pdfEngine.processPage(page);
        }
        catch (IOException e) {
            throw this.failure("page processing error: %s", e.getMessage());
        }
        for (Engine.TextElement element : pdfEngine.foundElements) {
            if (!element.text.contains(search)) continue;
            if (Logger.getGlobal().isLoggable(Level.FINER)) {
                Logger.getGlobal().finer("found text at " + String.valueOf(element.location));
            }
            if (!(fullyCovertArea ? area.contains(element.location) : area.intersects(element.location))) continue;
            return this;
        }
        throw this.failure("search string '%s' not found", search);
    }

    public PdfAssertions hasPageSize(int pageNum, float width, float height) {
        return this.hasPageSize(pageNum, new Rectangle2D.Float(0.0f, 0.0f, width, height));
    }

    public PdfAssertions hasPageSize(int pageNum, Rectangle2D expectedBox) {
        this.checkDocumentOK();
        this.checkValidPage(pageNum);
        PDPage page = this.document.getPage(pageNum - 1);
        PDRectangle mediaBox = page.getMediaBox();
        float EPS = 0.01f;
        float width = mediaBox.getWidth();
        float height = mediaBox.getHeight();
        if (Math.abs((double)width - expectedBox.getWidth()) > (double)0.01f || Math.abs((double)height - expectedBox.getHeight()) > (double)0.01f) {
            throw this.failure("page %d size %f \u00d7 %f pt differs from expected %f \u00d7 %f pt", pageNum, Float.valueOf(width), Float.valueOf(height), expectedBox.getWidth(), expectedBox.getHeight());
        }
        return this;
    }

    public PdfAssertions hasPageWidth(int pageNum, float expectedSize) {
        this.checkDocumentOK();
        this.checkValidPage(pageNum);
        PDPage page = this.document.getPage(pageNum - 1);
        PDRectangle mediaBox = page.getMediaBox();
        float EPS = 0.01f;
        float actualSize = mediaBox.getWidth();
        if (Math.abs(actualSize - expectedSize) > 0.01f) {
            throw this.failure("page %d width %f pt differs from expected %f pt", pageNum, Float.valueOf(actualSize), Float.valueOf(expectedSize));
        }
        return this;
    }

    public PdfAssertions hasPageHeight(int pageNum, float expectedSize) {
        this.checkDocumentOK();
        this.checkValidPage(pageNum);
        PDPage page = this.document.getPage(pageNum - 1);
        PDRectangle mediaBox = page.getMediaBox();
        float EPS = 0.01f;
        float actualSize = mediaBox.getHeight();
        if (Math.abs(actualSize - expectedSize) > 0.01f) {
            throw this.failure("page %d height %f pt differs from expected %f pt", pageNum, Float.valueOf(actualSize), Float.valueOf(expectedSize));
        }
        return this;
    }

    public PdfAssertions isPdfA() {
        return this.isPdfA(false, null);
    }

    public PdfAssertions isPdfA(boolean strict, String version) {
        this.checkDocumentOK();
        PDMetadata metadata = this.document.getDocumentCatalog().getMetadata();
        if (metadata == null) {
            throw this.failure("no XMP metadata found in document", new Object[0]);
        }
        try {
            XMPMeta xmp = XMPMetaFactory.parseFromBuffer((byte[])metadata.toByteArray());
            String namespace = "http://www.aiim.org/pdfa/ns/id/";
            String part = xmp.getPropertyString(namespace, "part");
            String conformance = xmp.getPropertyString(namespace, "conformance");
            if (part == null || conformance == null) {
                throw this.failure("PDF/A metadata incomplete: part=%s, conformance=%s", part, conformance);
            }
            if (strict) {
                if (version == null) {
                    if (!"a".equalsIgnoreCase(conformance)) {
                        throw this.failure("not a pdf/a: %s", conformance);
                    }
                } else if (!version.equalsIgnoreCase(part) || !"a".equalsIgnoreCase(conformance)) {
                    throw this.failure("not in allowed version: %s/%s", part, conformance);
                }
            }
        }
        catch (XMPException | IOException e) {
            throw this.failure("error reading PDF/A metadata: %s", e.getMessage());
        }
        return this;
    }

    private class Engine
    extends PDFTextStripper {
        private List<TextElement> foundElements = new ArrayList<TextElement>();

        public Engine() {
            this.addOperator((OperatorProcessor)new BeginText((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new Concatenate((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetStrokingColorSpace((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetNonStrokingColorSpace((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetLineDashPattern((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new EndText((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetStrokingDeviceGrayColor((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetNonStrokingDeviceGrayColor((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetGraphicsStateParameters((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetFlatness((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetLineJoinStyle((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetLineCapStyle((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetStrokingDeviceCMYKColor((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetNonStrokingDeviceCMYKColor((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetLineMiterLimit((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new Save((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new Restore((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetStrokingDeviceRGBColor((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetNonStrokingDeviceRGBColor((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetRenderingIntent((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetStrokingColor((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetNonStrokingColor((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetStrokingColorN((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetNonStrokingColorN((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new NextLine((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetCharSpacing((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new MoveText((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new MoveTextSetLeading((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetFontAndSize((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new ShowText((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new ShowTextAdjusted((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetTextLeading((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetMatrix((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetTextRenderingMode((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetTextRise((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetWordSpacing((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetTextHorizontalScaling((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetLineWidth((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new ShowTextLine((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new ShowTextLineAndSpace((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new BeginMarkedContentSequence((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new BeginMarkedContentSequenceWithProperties((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new EndMarkedContentSequence((PDFStreamEngine)this));
            this.output = new StringWriter();
        }

        protected void writeString(String text, List<TextPosition> textPositions) throws IOException {
            this.foundElements.add(new TextElement(text, this.calculateArea(textPositions)));
            super.writeString(text, textPositions);
        }

        protected Rectangle2D calculateArea(List<TextPosition> textPositions) {
            float maxX;
            if (textPositions == null || textPositions.isEmpty()) {
                return new Rectangle2D.Float(-1.0f, -1.0f, 0.0f, 0.0f);
            }
            TextPosition first = textPositions.get(0);
            float minX = first.getX();
            float minY = first.getY();
            float maxY = maxX = minX;
            for (TextPosition pos : textPositions) {
                if (pos.getX() < minX) {
                    minX = pos.getX();
                }
                if (pos.getY() < minY) {
                    minX = pos.getY();
                }
                float endX = pos.getX() + pos.getWidth();
                float endY = pos.getY() + pos.getHeight();
                if (endX > maxX) {
                    maxX = endX;
                }
                if (!(pos.getEndY() > maxY)) continue;
                maxY = endY;
            }
            return new Rectangle2D.Float(minX, minY, maxX - minX, maxY - minY);
        }

        protected void writeString(String text) throws IOException {
            super.writeString(text);
        }

        protected void processTextPosition(TextPosition text) {
            super.processTextPosition(text);
        }

        public void beginText() throws IOException {
            super.beginText();
        }

        public void endText() throws IOException {
            super.endText();
        }

        public void showTextString(byte[] string) throws IOException {
            super.showTextString(string);
        }

        public void showTextStrings(COSArray array) throws IOException {
            super.showTextStrings(array);
        }

        protected void showText(byte[] string) throws IOException {
            super.showText(string);
        }

        public void processPage(PDPage page) throws IOException {
            super.processPage(page);
        }

        protected void processSoftMask(PDTransparencyGroup group) throws IOException {
            super.processSoftMask(group);
        }

        protected void processTransparencyGroup(PDTransparencyGroup group) throws IOException {
            super.processTransparencyGroup(group);
        }

        protected void processType3Stream(PDType3CharProc charProc, Matrix textRenderingMatrix) throws IOException {
            super.processType3Stream(charProc, textRenderingMatrix);
        }

        protected void processAnnotation(PDAnnotation annotation, PDAppearanceStream appearance) throws IOException {
            super.processAnnotation(annotation, appearance);
        }

        protected void processChildStream(PDContentStream contentStream, PDPage page) throws IOException {
            super.processChildStream(contentStream, page);
        }

        protected void applyTextAdjustment(float tx, float ty) {
            super.applyTextAdjustment(tx, ty);
        }

        public void processOperator(String operation, List<COSBase> arguments) throws IOException {
            super.processOperator(operation, arguments);
        }

        protected void processOperator(Operator operator, List<COSBase> operands) throws IOException {
            super.processOperator(operator, operands);
        }

        public PDPage getCurrentPage() {
            return super.getCurrentPage();
        }

        public Point2D.Float transformedPoint(float x, float y) {
            return super.transformedPoint(x, y);
        }

        protected float transformWidth(float width) {
            return super.transformWidth(width);
        }

        public void markedContentPoint(COSName tag, COSDictionary properties) {
            super.markedContentPoint(tag, properties);
        }

        public void beginMarkedContentSequence(COSName tag, COSDictionary properties) {
            super.beginMarkedContentSequence(tag, properties);
        }

        public void endMarkedContentSequence() {
            super.endMarkedContentSequence();
        }

        public String getContent() {
            return this.output.toString();
        }

        class TextElement {
            String text;
            Rectangle2D location;

            public TextElement(String text, Rectangle2D location) {
                this.text = text;
                this.location = location;
            }
        }
    }
}

