/*
 * Decompiled with CFR 0.152.
 */
package net.qdevzone.docunit.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.qdevzone.docunit.AbstractDocAssert;
import net.qdevzone.docunit.DocumentAssert;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ImageAssertions
extends AbstractDocAssert<ImageAssertions> {
    private static final DocumentAssert.FileType[] ALLOWED_TYPES = new DocumentAssert.FileType[]{DocumentAssert.FileType.PNG, DocumentAssert.FileType.JPG, DocumentAssert.FileType.GIF};
    private final DocumentAssert base;
    private DocumentAssert.FileType type;
    private BufferedImage image;
    private Throwable loadError;
    private Map<String, String> metaData = new HashMap<String, String>();

    public ImageAssertions(DocumentAssert base, DocumentAssert.FileType type) {
        super(ImageAssertions.class);
        if (!Arrays.asList(ALLOWED_TYPES).contains((Object)type)) {
            throw new IllegalArgumentException(type.toString());
        }
        this.base = base;
        this.type = type;
        try {
            this.loadImage(base);
            this.loadMeta(base);
        }
        catch (IOException e) {
            this.loadError = e;
        }
    }

    private void loadImage(DocumentAssert base) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(base.actual());
        this.image = ImageIO.read(is);
        is.close();
    }

    private void loadMeta(DocumentAssert base) throws IOException {
        String[] metadataNames;
        ByteArrayInputStream is = new ByteArrayInputStream(base.actual());
        AutoDetectParser parser = new AutoDetectParser();
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        try {
            parser.parse((InputStream)is, (ContentHandler)handler, metadata, context);
        }
        catch (TikaException | SAXException e) {
            throw new IOException("could not read metadata", e);
        }
        String[] stringArray = metadataNames = metadata.names();
        int n = metadataNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.metaData.put(name, metadata.get(name));
            ++n2;
        }
        is.close();
    }

    public String mimeType() {
        Tika tika = new Tika();
        return tika.detect(this.base.actual());
    }

    @Override
    public ImageAssertions isValid() {
        if (this.loadError != null) {
            throw this.failure("unloadable image: %s", this.loadError.getMessage());
        }
        if (this.image == null) {
            throw this.failure("image loader returned null", new Object[0]);
        }
        return this;
    }

    @Override
    public ImageAssertions isNotValid() {
        if (this.loadError == null && this.image != null) {
            throw this.failure("image was valid", new Object[0]);
        }
        return this;
    }

    public ImageAssertions isPng() {
        if (!"image/png".equals(this.mimeType())) {
            throw this.failure("type is not PNG", new Object[0]);
        }
        return this;
    }

    public ImageAssertions isJpeg() {
        if (!"image/jpeg".equals(this.mimeType())) {
            throw this.failure("type is not JPEG", new Object[0]);
        }
        return this;
    }

    public ImageAssertions isGif() {
        if (!"image/gif".equals(this.mimeType())) {
            throw this.failure("type is not GIF", new Object[0]);
        }
        return this;
    }

    public ImageAssertions hasImageSize(int width, int height) {
        if (this.image.getWidth() != width || this.image.getHeight() != height) {
            throw this.failure("image size %d/%d does not match %d/%d", this.image.getWidth(), this.image.getHeight(), width, height);
        }
        return this;
    }

    public ImageAssertions hasKeyword(String expected) {
        if (!this.metaData.containsKey("Keywords")) {
            throw this.failure("Keyword metadata not found", new Object[0]);
        }
        String keywords = this.metaData.get("Keywords");
        if (!keywords.contains(expected)) {
            throw this.failure("Keyword %s not found in %s", expected, keywords);
        }
        return this;
    }

    public ImageAssertions hasCaption(String expected) {
        if (!this.metaData.containsKey("Caption/Abstract")) {
            throw this.failure("Caption metadata not found", new Object[0]);
        }
        String caption = this.metaData.get("Caption/Abstract");
        if (!caption.contains(expected)) {
            throw this.failure("Caption %s not found in %s", expected, expected);
        }
        return this;
    }

    public ImageAssertions hasAverageRgbDeltaLessThan(byte[] otherImageData, double maxDelta) {
        BufferedImage otherImage;
        try {
            otherImage = ImageIO.read(new ByteArrayInputStream(otherImageData));
        }
        catch (IOException e) {
            throw this.failureWithCause(e, "could not load compare image: " + e.getMessage(), new Object[0]);
        }
        if (this.image.getWidth() != otherImage.getWidth() || this.image.getHeight() != otherImage.getHeight()) {
            throw this.failure("image sizes do not match: %dx%d vs %dx%d", this.image.getWidth(), this.image.getHeight(), otherImage.getWidth(), otherImage.getHeight());
        }
        long totalPixels = (long)this.image.getWidth() * (long)this.image.getHeight();
        double totalDelta = 0.0;
        int y = 0;
        while (y < this.image.getHeight()) {
            int x = 0;
            while (x < this.image.getWidth()) {
                int rgb1 = this.image.getRGB(x, y);
                int rgb2 = otherImage.getRGB(x, y);
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                int r2 = rgb2 >> 16 & 0xFF;
                int g2 = rgb2 >> 8 & 0xFF;
                int b2 = rgb2 & 0xFF;
                double delta = Math.sqrt(Math.pow(r1 - r2, 2.0) + Math.pow(g1 - g2, 2.0) + Math.pow(b1 - b2, 2.0));
                totalDelta += delta;
                ++x;
            }
            ++y;
        }
        double averageDelta = totalDelta / (double)totalPixels;
        if (averageDelta > maxDelta) {
            throw this.failure("max delta (%.2f) beyond allowed (%.2f)", averageDelta, maxDelta);
        }
        return this;
    }

    @Override
    public byte[] actual() {
        return this.base.actual();
    }
}

