/*
 * Decompiled with CFR 0.152.
 */
package net.qdevzone.docunit.doc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import net.qdevzone.docunit.AbstractDocAssert;
import net.qdevzone.docunit.DocumentAssert;
import net.qdevzone.docunit.PagedDocAsserts;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;

public class WordAssertions
extends AbstractDocAssert<WordAssertions>
implements PagedDocAsserts<WordAssertions> {
    private final XWPFDocument document;
    private final DocumentAssert base;
    private Throwable loadError;

    public WordAssertions(DocumentAssert base) {
        super(WordAssertions.class);
        XWPFDocument loadadDoc = null;
        try {
            loadadDoc = new XWPFDocument((InputStream)new ByteArrayInputStream(base.actual()));
        }
        catch (IOException | NullPointerException ex) {
            this.loadError = ex;
        }
        this.document = loadadDoc;
        this.base = base;
    }

    @Override
    public WordAssertions isValid() {
        if (this.loadError != null) {
            throw this.failure("unloadable document: %s", this.loadError.getMessage());
        }
        if (this.document == null) {
            throw this.failure("document loader returned null", new Object[0]);
        }
        return this;
    }

    @Override
    public WordAssertions isNotValid() {
        if (this.loadError == null && this.document != null) {
            throw this.failure("document was valid", new Object[0]);
        }
        return this;
    }

    @Override
    public byte[] actual() {
        return this.base.actual();
    }

    private int pageCount() {
        try {
            XWPFWordExtractor extractor = new XWPFWordExtractor(this.document);
            int pageCount = extractor.getExtendedProperties().getPages();
            extractor.close();
            return pageCount;
        }
        catch (IOException e) {
            Logger.getGlobal().warning(e.getMessage());
            return -1;
        }
    }

    @Override
    public WordAssertions hasPages() {
        if (this.pageCount() == 0) {
            throw this.failure("no pages found", new Object[0]);
        }
        return this;
    }

    @Override
    public WordAssertions hasPageCount(int count) {
        int actualPages = this.pageCount();
        if (actualPages != count) {
            throw this.failure("page count %d differs from expected %d", actualPages, count);
        }
        return this;
    }

    @Override
    public WordAssertions hasPageCount(int min, int max) {
        int actualPages = this.pageCount();
        if (actualPages < min || actualPages > max) {
            throw this.failure("page count not in range %d >[ %d ]> %d", min, actualPages, max);
        }
        return this;
    }

    public WordAssertions hasContent(String expected) {
        List elements = this.document.getBodyElements();
        for (IBodyElement e : elements) {
            XWPFTable table;
            XWPFParagraph para;
            if (e instanceof XWPFParagraph && (para = (XWPFParagraph)e).getText().contains(expected)) {
                return this;
            }
            if (!(e instanceof XWPFTable) || !(table = (XWPFTable)e).getText().contains(expected)) continue;
            return this;
        }
        throw this.failure("text not found: %s", expected);
    }
}

