/*
 * Decompiled with CFR 0.152.
 */
package net.qdevzone.docunit.archive;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.qdevzone.docunit.AbstractDocAssert;
import net.qdevzone.docunit.DocumentAssert;

public class ZipAssertions
extends AbstractDocAssert<ZipAssertions> {
    private byte[] document;
    private final DocumentAssert base;
    private Throwable loadError;
    private List<ZipEntry> entries = new ArrayList<ZipEntry>();

    public ZipAssertions(DocumentAssert base) {
        super(ZipAssertions.class);
        this.document = base.actual();
        this.base = base;
        try {
            this.loadEntities();
        }
        catch (IOException | NullPointerException e) {
            this.loadError = e;
        }
    }

    private void loadEntities() throws IOException {
        ZipEntry entry;
        ByteArrayInputStream is = new ByteArrayInputStream(this.document);
        ZipInputStream zipStream = new ZipInputStream(is);
        while ((entry = zipStream.getNextEntry()) != null) {
            this.entries.add(entry);
        }
        is.close();
    }

    @Override
    public ZipAssertions isValid() {
        if (this.loadError != null) {
            throw this.failure("unloadable document: %s", this.loadError.getMessage());
        }
        if (this.document == null) {
            throw this.failure("document loader returned null", new Object[0]);
        }
        return this;
    }

    @Override
    public ZipAssertions isNotValid() {
        if (this.loadError == null && this.document != null) {
            throw this.failure("document was valid", new Object[0]);
        }
        return this;
    }

    public ZipAssertions containsElement(String expected) {
        for (ZipEntry e : this.entries) {
            if (!e.getName().equals(expected)) continue;
            return this;
        }
        throw this.failure("entity not found: %s", expected);
    }

    public ZipAssertions containsElement(String expected, long size) {
        for (ZipEntry e : this.entries) {
            if (!e.getName().equals(expected)) continue;
            if (e.getSize() == size) {
                return this;
            }
            throw this.failure("entity %s found with invalid size: %d but %d expected", expected, e.getSize(), size);
        }
        throw this.failure("entity not found: %s", expected);
    }

    @Override
    public byte[] actual() {
        return this.base.actual();
    }
}

