/*
 * Decompiled with CFR 0.152.
 */
package net.qdevzone.docunit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import net.qdevzone.docunit.AbstractDocAssert;
import net.qdevzone.docunit.archive.ZipAssertions;
import net.qdevzone.docunit.doc.WordAssertions;
import net.qdevzone.docunit.image.ImageAssertions;
import net.qdevzone.docunit.pdf.PdfAssertions;
import net.qdevzone.docunit.spreadsheet.ExcelAssertions;
import net.qdevzone.docunit.struct.CSVAssertions;
import net.qdevzone.docunit.struct.JSONAssertions;
import net.qdevzone.docunit.struct.XmlAssertions;
import net.qdevzone.docunit.text.TextAssertions;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class DocumentAssert
extends AbstractDocAssert<DocumentAssert> {
    private byte[] data;

    protected DocumentAssert(byte[] data) {
        super(DocumentAssert.class);
        this.data = data;
    }

    public static DocumentAssert forData(byte[] actual) {
        return new DocumentAssert(actual);
    }

    @Override
    public DocumentAssert isValid() {
        if (this.data == null) {
            throw this.failure("null", new Object[0]);
        }
        return (DocumentAssert)this.myself;
    }

    @Override
    public DocumentAssert isNotValid() {
        if (this.data != null) {
            throw this.failure("not null", new Object[0]);
        }
        return (DocumentAssert)this.myself;
    }

    public DocumentAssert isOfType(FileType ... types) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.data);
            TikaConfig tika = new TikaConfig();
            Metadata metadata = new Metadata();
            MediaType mimetype = tika.getDetector().detect((InputStream)TikaInputStream.get((InputStream)is), metadata);
            is.close();
            String mimeTypeString = mimetype.toString();
            boolean found = false;
            FileType[] fileTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                FileType type = fileTypeArray[n2];
                ArrayList<String> checkType = new ArrayList<String>();
                switch (type) {
                    case CSV: {
                        checkType.add("text/plain");
                        checkType.add("text/csv");
                        break;
                    }
                    case EXCEL: {
                        checkType.add("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                        break;
                    }
                    case GIF: {
                        checkType.add("image/gif");
                        break;
                    }
                    case JPG: {
                        checkType.add("image/jpeg");
                        break;
                    }
                    case PNG: {
                        checkType.add("image/png");
                        break;
                    }
                    case JSON: {
                        checkType.add("text/plain");
                        break;
                    }
                    case PDF: {
                        checkType.add("application/pdf");
                        break;
                    }
                    case RTF: {
                        checkType.add("application/rtf");
                        break;
                    }
                    case WORD: {
                        checkType.add("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
                        break;
                    }
                    case XML: {
                        checkType.add("text/plain");
                        checkType.add("text/xml");
                        break;
                    }
                    case ZIP: {
                        checkType.add("application/zip");
                    }
                }
                if (checkType.contains(mimeTypeString)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                throw this.failure("content not detected as any of %s", Arrays.toString((Object[])types));
            }
        }
        catch (IOException | TikaException e) {
            e.printStackTrace();
        }
        return this;
    }

    public ImageAssertions asGif() {
        return new ImageAssertions(this, FileType.GIF);
    }

    public ImageAssertions asJpeg() {
        return new ImageAssertions(this, FileType.JPG);
    }

    public ImageAssertions asPng() {
        return new ImageAssertions(this, FileType.PNG);
    }

    public WordAssertions asWord() {
        return new WordAssertions(this);
    }

    public ExcelAssertions asExcel() {
        return new ExcelAssertions(this);
    }

    public PdfAssertions asPdf() {
        return new PdfAssertions(this);
    }

    public TextAssertions asText() {
        return new TextAssertions(this);
    }

    public CSVAssertions asCsv() {
        return this.asCsv(",", true);
    }

    public CSVAssertions asCsv(String delimiter) {
        return this.asCsv(delimiter, true);
    }

    public CSVAssertions asCsv(String delimiter, boolean hasHeaders) {
        return new CSVAssertions(this, delimiter, hasHeaders);
    }

    public CSVAssertions asCsv(String delimiter, boolean hasHeaders, Charset charset) {
        return new CSVAssertions(this, delimiter, hasHeaders, charset);
    }

    public JSONAssertions asJson() {
        return new JSONAssertions(this);
    }

    public XmlAssertions asXml() {
        return new XmlAssertions(this);
    }

    public ZipAssertions asZip() {
        return new ZipAssertions(this);
    }

    @Override
    public byte[] actual() {
        return this.data;
    }

    public static enum FileType {
        WORD,
        EXCEL,
        CSV,
        JSON,
        XML,
        PDF,
        PNG,
        JPG,
        GIF,
        RTF,
        ZIP;

    }
}

