/*
 * Decompiled with CFR 0.152.
 */
package net.qdevzone.docunit;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import net.qdevzone.docunit.Assert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.internal.Failures;
import org.assertj.core.presentation.Representation;

public abstract class AbstractDocAssert<SELF extends Assert<SELF>>
implements Assert<SELF> {
    private static final String ORG_ASSERTJ = "org.assert";
    private static final String NET_QDEVZONE_DOCUNIT = "net.qdevzone.docunit";
    public WritableAssertionInfo info;
    protected final SELF myself;
    static Representation customRepresentation = null;

    protected AbstractDocAssert(Class<?> selfType) {
        this.myself = (Assert)selfType.cast(this);
        this.info = new WritableAssertionInfo(customRepresentation);
    }

    protected ByteArrayInputStream createInputStream() {
        return new ByteArrayInputStream(this.actual());
    }

    @Override
    public SELF isEmpty() {
        byte[] data = this.actual();
        if (data != null && data.length != 0) {
            throw this.failure("document not empty", new Object[0]);
        }
        return this.myself;
    }

    @Override
    public SELF isNotEmpty() {
        byte[] data = this.actual();
        if (data == null || data.length == 0) {
            throw this.failure("document not empty", new Object[0]);
        }
        return this.myself;
    }

    @Override
    public SELF isEqualTo(byte[] expected) {
        byte[] data = this.actual();
        if (expected == null) {
            if (data != null) {
                throw this.failure("not equal", new Object[0]);
            }
            return this.myself;
        }
        if (!expected.equals(data)) {
            throw this.failure("not equal", new Object[0]);
        }
        return this.myself;
    }

    @Override
    public SELF isNotEqualTo(byte[] other) {
        byte[] data = this.actual();
        if (other == null) {
            if (data == null) {
                throw this.failure("equal", new Object[0]);
            }
            return this.myself;
        }
        if (other.equals(data)) {
            throw this.failure("equal", new Object[0]);
        }
        return this.myself;
    }

    @Override
    public SELF isSize(long expected) {
        byte[] data = this.actual();
        if (data == null || (long)data.length != expected) {
            throw this.failure("size not %d", expected);
        }
        return this.myself;
    }

    @Override
    public SELF isSizeBetween(long min, long max) {
        byte[] data = this.actual();
        if (data == null || (long)data.length < min || (long)data.length > max) {
            throw this.failure("size not between %d and %d", min, max);
        }
        return this.myself;
    }

    @Override
    public SELF isIn(byte[] ... values) {
        byte[] data = this.actual();
        byte[][] byArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] expected = byArray[n2];
            if (expected == data) {
                return this.myself;
            }
            ++n2;
        }
        throw this.failure("not in values", new Object[0]);
    }

    @Override
    public SELF isNotIn(byte[] ... values) {
        byte[] data = this.actual();
        byte[][] byArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] expected = byArray[n2];
            if (expected == data) {
                throw this.failure("in values", new Object[0]);
            }
            ++n2;
        }
        return this.myself;
    }

    public SELF describedAs(String description) {
        this.info.description((Description)new TextDescription(description, new Object[0]));
        return this.myself;
    }

    public SELF describedAs(String description, Object ... args) {
        return this.describedAs((Description)new TextDescription(description, args));
    }

    public SELF describedAs(Description description) {
        this.info.description(description);
        return this.myself;
    }

    protected AssertionError failure(String errorMessage, Object ... arguments) {
        return this.failureWithCause(null, errorMessage, arguments);
    }

    protected AssertionError failureWithCause(Throwable cause, String errorMessage, Object ... arguments) {
        AssertionError assertionError = Failures.instance().failureIfErrorMessageIsOverridden((AssertionInfo)this.info);
        if (assertionError == null) {
            String description = MessageFormatter.instance().format(this.info.description(), this.info.representation(), "", new Object[0]);
            assertionError = new AssertionError((Object)(description + errorMessage.formatted(arguments)));
        }
        Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
        this.removeCustomAssertRelatedElementsFromStackTraceIfNeeded(assertionError);
        if (cause != null) {
            ((Throwable)((Object)assertionError)).initCause(cause);
        }
        return assertionError;
    }

    private void removeCustomAssertRelatedElementsFromStackTraceIfNeeded(AssertionError assertionError) {
        if (!Failures.instance().isRemoveAssertJRelatedElementsFromStackTrace()) {
            return;
        }
        if (this.isAssertjAssertClass()) {
            return;
        }
        if (this.isDocuUnitAssertClass()) {
            return;
        }
        StackTraceElement[] newStackTrace = (StackTraceElement[])Arrays.stream(((Throwable)((Object)assertionError)).getStackTrace()).filter(element -> !this.isElementOfCustomAssert((StackTraceElement)element)).toArray(StackTraceElement[]::new);
        ((Throwable)((Object)assertionError)).setStackTrace(newStackTrace);
    }

    private boolean isAssertjAssertClass() {
        return this.getClass().getName().startsWith(ORG_ASSERTJ);
    }

    private boolean isDocuUnitAssertClass() {
        return this.getClass().getName().startsWith(NET_QDEVZONE_DOCUNIT);
    }

    protected boolean isElementOfCustomAssert(StackTraceElement stackTraceElement) {
        Class<?> currentAssertClass = this.getClass();
        while (currentAssertClass != AbstractAssert.class) {
            if (stackTraceElement.getClassName().equals(currentAssertClass.getName())) {
                return true;
            }
            currentAssertClass = currentAssertClass.getSuperclass();
        }
        return false;
    }
}

