/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import net.pwall.util.MiniSet;

public class MiniSet3<T>
extends MiniSet<T> {
    private final T value0;
    private final T value1;
    private final T value2;

    public MiniSet3(T value0, T value1, T value2) {
        this.value0 = value0;
        this.value1 = value1;
        this.value2 = value2;
    }

    public MiniSet3(Set<T> set) {
        if (set.size() != 3) {
            throw new IllegalArgumentException("MiniSet3 size must be 3");
        }
        if (set instanceof MiniSet3) {
            MiniSet3 miniSet3 = (MiniSet3)set;
            this.value0 = miniSet3.value0;
            this.value1 = miniSet3.value1;
            this.value2 = miniSet3.value2;
        } else {
            Iterator<T> iterator = set.iterator();
            this.value0 = iterator.next();
            this.value1 = iterator.next();
            this.value2 = iterator.next();
        }
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return o == null ? this.value0 == null || this.value1 == null || this.value2 == null : o.equals(this.value0) || o.equals(this.value1) || o.equals(this.value2);
    }

    @Override
    public Iterator<T> iterator() {
        return new Miniterator();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.value0, this.value1, this.value2};
    }

    @Override
    public <TT> TT[] toArray(TT[] a) {
        if (a.length < 3) {
            return new Object[]{this.value0, this.value1, this.value2};
        }
        TT[] target = a;
        target[0] = this.value0;
        target[1] = this.value1;
        target[2] = this.value2;
        if (target.length > 3) {
            target[3] = null;
        }
        return a;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set otherSet = (Set)other;
        return otherSet.size() == 3 && otherSet.contains(this.value0) && otherSet.contains(this.value1) && otherSet.contains(this.value2);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.value0) + Objects.hashCode(this.value1) + Objects.hashCode(this.value2);
    }

    @Override
    public String toString() {
        return "[" + this.stringOf(this.value0) + ", " + this.stringOf(this.value1) + ", " + this.stringOf(this.value2) + ']';
    }

    public class Miniterator
    implements Iterator<T> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < 3;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this.index == 0 ? MiniSet3.this.value0 : (this.index == 1 ? MiniSet3.this.value1 : MiniSet3.this.value2);
            ++this.index;
            return result;
        }
    }
}

