/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import net.pwall.util.MiniSet;

public class MiniSet2<T>
extends MiniSet<T> {
    private final T value0;
    private final T value1;

    public MiniSet2(T value0, T value1) {
        this.value0 = value0;
        this.value1 = value1;
    }

    public MiniSet2(Set<T> set) {
        if (set.size() != 2) {
            throw new IllegalArgumentException("MiniSet2 size must be 2");
        }
        if (set instanceof MiniSet2) {
            MiniSet2 miniSet2 = (MiniSet2)set;
            this.value0 = miniSet2.value0;
            this.value1 = miniSet2.value1;
        } else {
            Iterator<T> iterator = set.iterator();
            this.value0 = iterator.next();
            this.value1 = iterator.next();
        }
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return o == null ? this.value0 == null || this.value1 == null : o.equals(this.value0) || o.equals(this.value1);
    }

    @Override
    public Iterator<T> iterator() {
        return new Miniterator();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.value0, this.value1};
    }

    @Override
    public <TT> TT[] toArray(TT[] a) {
        if (a.length < 2) {
            return new Object[]{this.value0, this.value1};
        }
        TT[] target = a;
        target[0] = this.value0;
        target[1] = this.value1;
        if (target.length > 2) {
            target[2] = null;
        }
        return a;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set otherSet = (Set)other;
        return otherSet.size() == 2 && otherSet.contains(this.value0) && otherSet.contains(this.value1);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.value0) + Objects.hashCode(this.value1);
    }

    @Override
    public String toString() {
        return "[" + this.stringOf(this.value0) + ", " + this.stringOf(this.value1) + ']';
    }

    public class Miniterator
    implements Iterator<T> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < 2;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this.index == 0 ? MiniSet2.this.value0 : MiniSet2.this.value1;
            ++this.index;
            return result;
        }
    }
}

