/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.pwall.util.MiniMap;
import net.pwall.util.MiniSet2;

public class MiniMap2<K, V>
extends MiniMap<K, V> {
    private final K key0;
    private final V value0;
    private final K key1;
    private final V value1;

    public MiniMap2(K key0, V value0, K key1, V value1) {
        this.key0 = key0;
        this.value0 = value0;
        this.key1 = key1;
        this.value1 = value1;
    }

    public MiniMap2(Map<K, V> map) {
        if (map.size() != 2) {
            throw new IllegalArgumentException("MiniMap2 size must be 2");
        }
        if (map instanceof MiniMap2) {
            MiniMap2 miniMap2 = (MiniMap2)map;
            this.key0 = miniMap2.key0;
            this.value0 = miniMap2.value0;
            this.key1 = miniMap2.key1;
            this.value1 = miniMap2.value1;
        } else {
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            Map.Entry<K, V> entry = iterator.next();
            this.key0 = entry.getKey();
            this.value0 = entry.getValue();
            entry = iterator.next();
            this.key1 = entry.getKey();
            this.value1 = entry.getValue();
        }
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return key == null ? this.key0 == null || this.key1 == null : key.equals(this.key0) || key.equals(this.key1);
    }

    @Override
    public boolean containsValue(Object value) {
        return value == null ? this.value0 == null || this.value1 == null : value.equals(this.value0) || value.equals(this.value1);
    }

    @Override
    public V get(Object key) {
        return (V)(key == null ? (this.key0 == null ? this.value0 : (this.key1 == null ? this.value1 : null)) : (key.equals(this.key0) ? this.value0 : (key.equals(this.key1) ? this.value1 : null)));
    }

    @Override
    public Set<K> keySet() {
        return new MiniSet2<K>(this.key0, this.key1);
    }

    @Override
    public Collection<V> values() {
        return new MiniSet2<V>(this.value0, this.value1);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new MiniSet2<Map.Entry<K, V>>(MiniMap2.entry(this.key0, this.value0), MiniMap2.entry(this.key1, this.value1));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map otherMap = (Map)other;
        return otherMap.size() == 2 && otherMap.containsKey(this.key0) && Objects.equals(this.value0, otherMap.get(this.key0)) && otherMap.containsKey(this.key1) && Objects.equals(this.value1, otherMap.get(this.key1));
    }

    @Override
    public int hashCode() {
        return (Objects.hashCode(this.key0) ^ Objects.hashCode(this.value0)) + (Objects.hashCode(this.key1) ^ Objects.hashCode(this.value1));
    }

    @Override
    public String toString() {
        return "{" + this.stringOf(this.key0) + '=' + this.stringOf(this.value0) + ", " + this.stringOf(this.key1) + '=' + this.stringOf(this.value1) + '}';
    }
}

